/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.opendaylight.mdsal.binding.api.DataTreeCommitCohort;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMDataTreeCommitCohortAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.ConstantAdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.CurrentAdapterSerializer;
import org.opendaylight.mdsal.binding.dom.adapter.LazyDataTreeModification;
import org.opendaylight.mdsal.binding.dom.codec.api.BindingDataObjectCodecTreeNode;
import org.opendaylight.mdsal.binding.dom.codec.spi.BindingDOMCodecServices;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.common.api.PostCanCommitStep;
import org.opendaylight.mdsal.dom.api.DOMDataTreeCandidate;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.yang.gen.v1.urn.yang.foo.rev160101.BooleanContainer;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.data.tree.api.DataTreeCandidateNode;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class BindingDOMDataTreeCommitCohortAdapterTest {
    @Test
    public void canCommitTest() {
        DataTreeCommitCohort cohort = (DataTreeCommitCohort)Mockito.mock(DataTreeCommitCohort.class);
        BindingDOMCodecServices registry = (BindingDOMCodecServices)Mockito.mock(BindingDOMCodecServices.class);
        ConstantAdapterContext codec = new ConstantAdapterContext(registry);
        BindingDOMDataTreeCommitCohortAdapter adapter = new BindingDOMDataTreeCommitCohortAdapter((AdapterContext)codec, cohort);
        Assert.assertNotNull((Object)adapter);
        DOMDataTreeCandidate domDataTreeCandidate = (DOMDataTreeCandidate)Mockito.mock(DOMDataTreeCandidate.class);
        DOMDataTreeIdentifier domDataTreeIdentifier = new DOMDataTreeIdentifier(LogicalDatastoreType.OPERATIONAL, YangInstanceIdentifier.empty());
        ((BindingDOMCodecServices)Mockito.doReturn((Object)InstanceIdentifier.create(BooleanContainer.class)).when((Object)registry)).fromYangInstanceIdentifier((YangInstanceIdentifier)ArgumentMatchers.any());
        BindingDataObjectCodecTreeNode bindingCodecTreeNode = (BindingDataObjectCodecTreeNode)Mockito.mock(BindingDataObjectCodecTreeNode.class);
        ((BindingDOMCodecServices)Mockito.doReturn((Object)bindingCodecTreeNode).when((Object)registry)).getSubtreeCodec((InstanceIdentifier)ArgumentMatchers.any(InstanceIdentifier.class));
        ((DOMDataTreeCandidate)Mockito.doReturn((Object)domDataTreeIdentifier).when((Object)domDataTreeCandidate)).getRootPath();
        ((DOMDataTreeCandidate)Mockito.doReturn((Object)Mockito.mock(DataTreeCandidateNode.class)).when((Object)domDataTreeCandidate)).getRootNode();
        Assert.assertNotNull((Object)LazyDataTreeModification.create((CurrentAdapterSerializer)codec.currentSerializer(), (DOMDataTreeCandidate)domDataTreeCandidate));
        Object txId = new Object();
        ((DataTreeCommitCohort)Mockito.doReturn((Object)PostCanCommitStep.NOOP_SUCCESSFUL_FUTURE).when((Object)cohort)).canCommit(ArgumentMatchers.any(), (Collection)ArgumentMatchers.any());
        adapter.canCommit(txId, null, List.of(domDataTreeCandidate, domDataTreeCandidate));
        ArgumentCaptor modifications = ArgumentCaptor.forClass(Collection.class);
        ((DataTreeCommitCohort)Mockito.verify((Object)cohort)).canCommit(ArgumentMatchers.eq((Object)txId), (Collection)modifications.capture());
        Assert.assertEquals((long)2L, (long)((Collection)modifications.getValue()).size());
    }
}

