/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import java.util.Collection;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.AdditionalMatchers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.opendaylight.mdsal.binding.api.ClusteredDataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeIdentifier;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.mdsal.binding.dom.adapter.AdapterContext;
import org.opendaylight.mdsal.binding.dom.adapter.BindingDOMDataTreeChangeServiceAdapter;
import org.opendaylight.mdsal.binding.dom.adapter.ConstantAdapterContext;
import org.opendaylight.mdsal.binding.dom.codec.spi.BindingDOMCodecServices;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.ClusteredDOMDataTreeChangeListener;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeListener;
import org.opendaylight.mdsal.dom.api.DOMDataTreeChangeService;
import org.opendaylight.mdsal.dom.api.DOMDataTreeIdentifier;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.test.binding.rev140701.Top;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class BindingDOMDataTreeChangeServiceAdapterTest {
    private static final InstanceIdentifier<Top> TOP_PATH = InstanceIdentifier.create(Top.class);
    private static final YangInstanceIdentifier TOP_YIID = YangInstanceIdentifier.of((QName)Top.QNAME);
    @Mock
    private DOMDataTreeChangeService mockDOMService;
    @Mock
    private BindingDOMCodecServices services;
    @Mock
    private ListenerRegistration mockDOMReg;

    @Before
    public void setUp() {
        ((BindingDOMCodecServices)Mockito.doReturn((Object)TOP_YIID).when((Object)this.services)).toYangInstanceIdentifier(TOP_PATH);
    }

    @Test
    public void testRegisterDataTreeChangeListener() {
        ConstantAdapterContext codec = new ConstantAdapterContext(this.services);
        BindingDOMDataTreeChangeServiceAdapter service = new BindingDOMDataTreeChangeServiceAdapter((AdapterContext)codec, this.mockDOMService);
        ((DOMDataTreeChangeService)Mockito.doReturn((Object)this.mockDOMReg).when((Object)this.mockDOMService)).registerDataTreeChangeListener(BindingDOMDataTreeChangeServiceAdapterTest.domDataTreeIdentifier(TOP_YIID), (DOMDataTreeChangeListener)ArgumentMatchers.any(DOMDataTreeChangeListener.class));
        DataTreeIdentifier treeId = DataTreeIdentifier.create((LogicalDatastoreType)LogicalDatastoreType.CONFIGURATION, TOP_PATH);
        TestClusteredDataTreeChangeListener mockClusteredListener = new TestClusteredDataTreeChangeListener();
        service.registerDataTreeChangeListener(treeId, (DataTreeChangeListener)mockClusteredListener);
        ((DOMDataTreeChangeService)Mockito.verify((Object)this.mockDOMService)).registerDataTreeChangeListener(BindingDOMDataTreeChangeServiceAdapterTest.domDataTreeIdentifier(TOP_YIID), (DOMDataTreeChangeListener)((ClusteredDOMDataTreeChangeListener)ArgumentMatchers.isA(ClusteredDOMDataTreeChangeListener.class)));
        Mockito.reset((Object[])new DOMDataTreeChangeService[]{this.mockDOMService});
        ((DOMDataTreeChangeService)Mockito.doReturn((Object)this.mockDOMReg).when((Object)this.mockDOMService)).registerDataTreeChangeListener(BindingDOMDataTreeChangeServiceAdapterTest.domDataTreeIdentifier(TOP_YIID), (DOMDataTreeChangeListener)ArgumentMatchers.any(DOMDataTreeChangeListener.class));
        TestDataTreeChangeListener mockNonClusteredListener = new TestDataTreeChangeListener();
        service.registerDataTreeChangeListener(treeId, (DataTreeChangeListener)mockNonClusteredListener);
        ((DOMDataTreeChangeService)Mockito.verify((Object)this.mockDOMService)).registerDataTreeChangeListener(BindingDOMDataTreeChangeServiceAdapterTest.domDataTreeIdentifier(TOP_YIID), (DOMDataTreeChangeListener)((ClusteredDOMDataTreeChangeListener)AdditionalMatchers.not((Object)((ClusteredDOMDataTreeChangeListener)ArgumentMatchers.isA(ClusteredDOMDataTreeChangeListener.class)))));
    }

    static DOMDataTreeIdentifier domDataTreeIdentifier(YangInstanceIdentifier yangID) {
        return (DOMDataTreeIdentifier)ArgumentMatchers.argThat(arg -> arg.getDatastoreType() == LogicalDatastoreType.CONFIGURATION && yangID.equals((Object)arg.getRootIdentifier()));
    }

    private static class TestClusteredDataTreeChangeListener
    implements ClusteredDataTreeChangeListener<Top> {
        private TestClusteredDataTreeChangeListener() {
        }

        public void onDataTreeChanged(Collection<DataTreeModification<Top>> changes) {
        }
    }

    private static class TestDataTreeChangeListener
    implements DataTreeChangeListener<Top> {
        private TestDataTreeChangeListener() {
        }

        public void onDataTreeChanged(Collection<DataTreeModification<Top>> changes) {
        }
    }
}

