/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.dom.adapter;

import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.opendaylight.mdsal.binding.api.ActionProviderService;
import org.opendaylight.mdsal.binding.api.ActionSpec;
import org.opendaylight.mdsal.binding.dom.adapter.AbstractActionAdapterTest;
import org.opendaylight.mdsal.binding.dom.adapter.ActionProviderServiceAdapter;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.mdsal.dom.api.DOMActionImplementation;
import org.opendaylight.mdsal.dom.api.DOMActionInstance;
import org.opendaylight.mdsal.dom.api.DOMActionProviderService;
import org.opendaylight.yang.gen.v1.urn.odl.actions.norev.Cont;
import org.opendaylight.yang.gen.v1.urn.odl.actions.norev.Lstio;
import org.opendaylight.yang.gen.v1.urn.odl.actions.norev.LstioKey;
import org.opendaylight.yang.gen.v1.urn.odl.actions.norev.cont.Foo;
import org.opendaylight.yang.gen.v1.urn.odl.actions.norev.lstio.Fooio;
import org.opendaylight.yangtools.yang.binding.Action;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.RpcResultBuilder;
import org.opendaylight.yangtools.yang.data.api.YangInstanceIdentifier;
import org.opendaylight.yangtools.yang.model.api.stmt.SchemaNodeIdentifier;

@RunWith(value=MockitoJUnitRunner.StrictStubs.class)
public class ActionProviderServiceAdapterTest
extends AbstractActionAdapterTest {
    private static final @NonNull Foo FOO = (path, input) -> RpcResultBuilder.success((Object)BINDING_FOO_OUTPUT).buildFuture();
    private static final @NonNull Fooio FOOIO = (path, input) -> RpcResultBuilder.success((Object)BINDING_LSTIO_OUTPUT).buildFuture();
    private static final @NonNull QName KEYIO_QNAME = QName.create((QName)Lstio.QNAME, (String)"keyio");
    private static final String LIST_KEY = "list-key";
    @Mock
    private DOMActionProviderService actionProvider;
    private ActionProviderService adapter;

    @Override
    @Before
    public void before() {
        super.before();
        this.adapter = new ActionProviderServiceAdapter(this.codec, this.actionProvider);
    }

    @Test
    public void testInstanceRegistration() {
        this.adapter.registerImplementation(ActionSpec.builder(Cont.class).build(Foo.class), (Action)FOO, LogicalDatastoreType.OPERATIONAL, Set.of(InstanceIdentifier.create(Cont.class)));
        ((DOMActionProviderService)Mockito.verify((Object)this.actionProvider)).registerActionImplementation((DOMActionImplementation)ArgumentMatchers.any(), (DOMActionInstance)ArgumentMatchers.eq((Object)DOMActionInstance.of((SchemaNodeIdentifier.Absolute)FOO_PATH, (LogicalDatastoreType)LogicalDatastoreType.OPERATIONAL, (YangInstanceIdentifier)YangInstanceIdentifier.create((YangInstanceIdentifier.PathArgument)new YangInstanceIdentifier.NodeIdentifier(Cont.QNAME)))));
    }

    @Test
    public void testKeyedInstanceRegistration() {
        InstanceIdentifier identifier = InstanceIdentifier.builder(Lstio.class, (Identifier)new LstioKey(LIST_KEY)).build();
        this.adapter.registerImplementation(ActionSpec.builder(Lstio.class).build(Fooio.class), (Action)FOOIO, LogicalDatastoreType.OPERATIONAL, Set.of(identifier));
        YangInstanceIdentifier lstioYIID = YangInstanceIdentifier.builder().node(Lstio.QNAME).nodeWithKey(Lstio.QNAME, KEYIO_QNAME, (Object)LIST_KEY).build();
        ((DOMActionProviderService)Mockito.verify((Object)this.actionProvider)).registerActionImplementation((DOMActionImplementation)ArgumentMatchers.any(), (DOMActionInstance)ArgumentMatchers.eq((Object)DOMActionInstance.of((SchemaNodeIdentifier.Absolute)FOOIO_PATH, (LogicalDatastoreType)LogicalDatastoreType.OPERATIONAL, (YangInstanceIdentifier)lstioYIID)));
    }

    @Test
    public void testWildcardRegistration() {
        this.adapter.registerImplementation(ActionSpec.builder(Cont.class).build(Foo.class), (Action)FOO);
        ((DOMActionProviderService)Mockito.verify((Object)this.actionProvider)).registerActionImplementation((DOMActionImplementation)ArgumentMatchers.any(), (DOMActionInstance)ArgumentMatchers.eq((Object)DOMActionInstance.of((SchemaNodeIdentifier.Absolute)FOO_PATH, (LogicalDatastoreType)LogicalDatastoreType.OPERATIONAL, (YangInstanceIdentifier)YangInstanceIdentifier.empty())));
    }
}

