/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.api;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.binding.Augmentation;
import org.opendaylight.yangtools.binding.ChildOf;
import org.opendaylight.yangtools.binding.ChoiceIn;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.DataObjectReference;
import org.opendaylight.yangtools.binding.DataRoot;
import org.opendaylight.yangtools.binding.InstanceNotification;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.concepts.Mutable;

@Beta
public final class InstanceNotificationSpec<N extends InstanceNotification<N, P>, P extends DataObject>
implements Immutable {
    private final @NonNull DataObjectReference<P> path;
    private final @NonNull Class<N> type;

    private InstanceNotificationSpec(@NonNull Class<N> type, @NonNull DataObjectReference<P> path) {
        this.type = Objects.requireNonNull(type);
        this.path = Objects.requireNonNull(path);
    }

    public static <P extends ChildOf<? extends DataRoot<?>>> @NonNull Builder<P> builder(@NonNull Class<P> container) {
        return new Builder(DataObjectReference.builder(container));
    }

    public static <C extends ChoiceIn<? extends DataRoot<?>> & DataObject, P extends ChildOf<? super C>> @NonNull Builder<P> builder(@NonNull Class<C> caze, @NonNull Class<P> container) {
        return new Builder(DataObjectReference.builder(caze, container));
    }

    public @NonNull DataObjectReference<P> path() {
        return this.path;
    }

    public @NonNull Class<N> type() {
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.path);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof InstanceNotificationSpec)) return false;
        InstanceNotificationSpec other = (InstanceNotificationSpec)obj;
        if (!this.type.equals(other.type)) return false;
        if (!this.path.equals(other.path)) return false;
        return true;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("action", this.type).add("path", this.path).toString();
    }

    @Beta
    public static final class Builder<P extends DataObject>
    implements Mutable {
        private final DataObjectReference.Builder<P> pathBuilder;

        Builder(DataObjectReference.Builder<P> pathBuilder) {
            this.pathBuilder = Objects.requireNonNull(pathBuilder);
        }

        public <N extends ChildOf<? super P>> @NonNull Builder<N> withPathChild(@NonNull Class<N> container) {
            this.pathBuilder.child(container);
            return this.castThis();
        }

        public <C extends ChoiceIn<? super P> & DataObject, N extends ChildOf<? super C>> @NonNull Builder<N> withPathChild(@NonNull Class<C> caze, @NonNull Class<N> container) {
            this.pathBuilder.child(caze, container);
            return this.castThis();
        }

        public <A extends Augmentation<? super P>> @NonNull Builder<A> withPathAugmentation(@NonNull Class<A> augmentation) {
            this.pathBuilder.augmentation(augmentation);
            return this.castThis();
        }

        public <N extends InstanceNotification<N, P>> @NonNull InstanceNotificationSpec<N, P> build(@NonNull Class<N> type) {
            return new InstanceNotificationSpec(type, this.pathBuilder.build());
        }

        private <N extends DataObject> @NonNull Builder<N> castThis() {
            return this;
        }
    }
}

