/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.api;

import com.google.common.collect.ForwardingObject;
import java.util.List;
import java.util.Objects;
import org.opendaylight.mdsal.binding.api.DataChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeChangeListener;
import org.opendaylight.mdsal.binding.api.DataTreeModification;
import org.opendaylight.yangtools.binding.DataObject;

final class DataChangeListenerAdapter<T extends DataObject>
extends ForwardingObject
implements DataTreeChangeListener<T> {
    private final DataChangeListener<T> delegate;

    DataChangeListenerAdapter(DataChangeListener<T> delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public void onDataTreeChanged(List<DataTreeModification<T>> changes) {
        this.delegate.dataChanged(changes.get(0).getRootNode().dataBefore(), changes.get(changes.size() - 1).getRootNode().dataAfter());
    }

    @Override
    public void onInitialData() {
        this.delegate.dataChanged(null, null);
    }

    protected DataChangeListener<T> delegate() {
        return this.delegate;
    }
}

