/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.mdsal.binding.api;

import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.LegacyUtils;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yangtools.binding.DataObject;
import org.opendaylight.yangtools.binding.DataObjectIdentifier;
import org.opendaylight.yangtools.binding.DataObjectReference;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;

public interface ReadOperations {
    public <T extends DataObject> @NonNull FluentFuture<Optional<T>> read(@NonNull LogicalDatastoreType var1, @NonNull DataObjectIdentifier<T> var2);

    @Deprecated(since="14.0.0", forRemoval=true)
    default public <T extends DataObject> @NonNull FluentFuture<Optional<T>> read(@NonNull LogicalDatastoreType store, @NonNull InstanceIdentifier<T> path) {
        return this.read(store, LegacyUtils.legacyToIdentifier(path));
    }

    default public @NonNull FluentFuture<Boolean> exists(@NonNull LogicalDatastoreType store, @NonNull DataObjectIdentifier<?> path) {
        return this.read(store, path).transform(Optional::isPresent, MoreExecutors.directExecutor());
    }

    default public @NonNull FluentFuture<Boolean> exists(@NonNull LogicalDatastoreType store, @NonNull DataObjectReference<?> path) {
        DataObjectReference<?> dataObjectReference = path;
        Objects.requireNonNull(dataObjectReference);
        DataObjectReference<?> dataObjectReference2 = dataObjectReference;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataObjectIdentifier.class, InstanceIdentifier.class}, dataObjectReference2, n)) {
            case 0 -> {
                DataObjectIdentifier id = (DataObjectIdentifier)dataObjectReference2;
                yield this.exists(store, id);
            }
            case 1 -> {
                InstanceIdentifier id = (InstanceIdentifier)dataObjectReference2;
                yield this.exists(store, id.toReference());
            }
            default -> throw new IllegalArgumentException("Unsuported reference " + String.valueOf(path));
        };
    }

    @Deprecated(since="14.0.0", forRemoval=true)
    default public @NonNull FluentFuture<Boolean> exists(@NonNull LogicalDatastoreType store, @NonNull InstanceIdentifier<?> path) {
        return this.exists(store, path.toReference());
    }
}

