/*
 * Decompiled with CFR 0.152.
 */
package akka.persistence;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.actor.Deploy$;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.ExtensionId;
import akka.actor.Props;
import akka.actor.Scope;
import akka.annotation.InternalApi;
import akka.annotation.InternalStableApi;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.japi.Pair;
import akka.persistence.Persistence$;
import akka.persistence.PersistenceSettings;
import akka.persistence.RecoveryPermitter$;
import akka.persistence.StashOverflowStrategy;
import akka.persistence.StashOverflowStrategyConfigurator;
import akka.persistence.journal.EventAdapters;
import akka.persistence.journal.EventAdapters$;
import akka.persistence.journal.IdentityEventAdapters$;
import akka.routing.RouterConfig;
import akka.util.Collections$EmptyImmutableSeq$;
import akka.util.Reflect$;
import akka.util.ccompat.package$JavaConverters$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\rEx!B-[\u0011\u0003yf!B1[\u0011\u0003\u0011\u0007B\u0002>\u0002\t\u0003\u0019\t\u0007C\u0004\u0004d\u0005!\te!\u001a\t\u000f\r\r\u0014\u0001\"\u0011\u0004p!911C\u0001\u0005\u0002\re\u0004bBB?\u0003\u0011\u00051q\u0010\u0004\b\u0003K\u000b\u0001IWAT\u0011)\t\tm\u0002BK\u0002\u0013\u0005\u00111\u0019\u0005\u000b\u0003\u0017<!\u0011#Q\u0001\n\u0005\u0015\u0007BCAg\u000f\tU\r\u0011\"\u0001\u0002P\"Q\u0011Q\\\u0004\u0003\u0012\u0003\u0006I!!5\t\u0015\u0005\u0005rA!f\u0001\n\u0003\t\u0019\u0003\u0003\u0006\u00028\u001d\u0011\t\u0012)A\u0005\u0003KAaA_\u0004\u0005\u0002\u0005}\u0007\"\u00037\b\u0011\u000b\u0007I\u0011AA\u001e\u0011%\tYoBA\u0001\n\u0003\ti\u000fC\u0005\u0002v\u001e\t\n\u0011\"\u0001\u0002x\"I!1B\u0004\u0012\u0002\u0013\u0005!Q\u0002\u0005\n\u0005#9\u0011\u0013!C\u0001\u0005'A\u0011Ba\u0006\b\u0003\u0003%\t%!\u0004\t\u0013\teq!!A\u0005\u0002\tm\u0001\"\u0003B\u0012\u000f\u0005\u0005I\u0011\u0001B\u0013\u0011%\u0011\tdBA\u0001\n\u0003\u0012\u0019\u0004C\u0005\u0003B\u001d\t\t\u0011\"\u0001\u0003D!I!QJ\u0004\u0002\u0002\u0013\u0005#q\n\u0005\n\u0005':\u0011\u0011!C!\u0005+B\u0011Ba\u0016\b\u0003\u0003%\tE!\u0017\t\u0013\tms!!A\u0005B\tusACBA\u0003\u0005\u0005\t\u0012\u0001.\u0004\u0004\u001aQ\u0011QU\u0001\u0002\u0002#\u0005!l!\"\t\ritB\u0011ABO\u0011%\u00119FHA\u0001\n\u000b\u0012I\u0006C\u0005\u0004 z\t\t\u0011\"!\u0004\"\"I1\u0011\u0016\u0010\u0002\u0002\u0013\u000551\u0016\u0005\n\u0007{s\u0012\u0011!C\u0005\u0007\u007fC\u0011ba2\u0002\u0005\u0004%\t!!\u0004\t\u0011\r%\u0017\u0001)A\u0005\u0003\u001fA\u0011ba3\u0002\u0005\u0004%\t!!\u0004\t\u0011\r5\u0017\u0001)A\u0005\u0003\u001fA\u0001ba4\u0002\t\u0003a6\u0011\u001b\u0005\t\u0007?\fA\u0011\u0001/\u0004b\"91\u0011^\u0001\u0005\n\r-h\u0001B1[\u0001AD\u0001\u0002^\u0016\u0003\u0006\u0004%\t!\u001e\u0005\ts.\u0012\t\u0011)A\u0005m\")!p\u000bC\u0001w\")Qp\u000bC\u0005}\"I\u00111B\u0016C\u0002\u0013%\u0011Q\u0002\u0005\t\u0003?Y\u0003\u0015!\u0003\u0002\u0010!I\u0011\u0011E\u0016C\u0002\u0013%\u00111\u0005\u0005\t\u0003oY\u0003\u0015!\u0003\u0002&!Q\u0011\u0011H\u0016C\u0002\u0013\u0005A,a\u000f\t\u0011\u0005\r3\u0006)A\u0005\u0003{A!\"a\u0015,\u0011\u000b\u0007I\u0011BA\u0007\u0011)\t)f\u000bEC\u0002\u0013%\u0011Q\u0002\u0005\u000b\u0003/Z\u0003R1A\u0005\u0002\u0005e\u0003\"CA1W\t\u0007I\u0011AA2\u0011!\tYg\u000bQ\u0001\n\u0005\u0015\u0004\"CA7W\t\u0007I\u0011BA8\u0011!\u0011\tg\u000bQ\u0001\n\u0005E\u0004b\u0002B2W\u0011%!Q\r\u0005\b\u0005kZC\u0011\u0002B<\u0011\u001d\u0011ih\u000bC\u0003\u0005\u007fBqA! ,\t\u000b\u0011)\t\u0003\u0005\u0003~-\")\u0001\u0018BG\u0011!\u0011\u0019j\u000bC\u00039\nU\u0005B\u0003BNWE\u0005IQ\u0001/\u0003\u0014!A!QT\u0016\u0005\u0006q\u0013y\n\u0003\u0005\u0003$.\")\u0001\u0018BS\u0011)\u0011\u0019lKI\u0001\n\u000ba&1\u0003\u0005\t\u0005k[CQ\u0001/\u00038\"Q!1Y\u0016\u0012\u0002\u0013\u0015ALa\u0005\t\u000f\t\u00157\u0006\"\u0003\u0003H\"9!Q\\\u0016\u0005\n\t}\u0007b\u0002BsW\u0011%!q\u001d\u0005\b\u0005[\\C\u0011\u0001Bx\u0011\u001d\u0011)p\u000bC\u0005\u0005o4aA!@,\t\t}\bB\u0003B:\u001d\n\u0005\t\u0015!\u0003\u0002\u001c\"Q!Q\u001a(\u0003\u0002\u0003\u0006I!a'\t\u0015\tEgJ!A!\u0002\u0013\t)\u0003\u0003\u0004{\u001d\u0012\u00051\u0011\u0001\u0005\u0007u:#\ta!\u0004\t\u000f\rMa\n\"\u0011\u0004\u0016!91\u0011D\u0016\u0005\u0006\tm\u0001bBB\u000eW\u0011\u00151Q\u0004\u0005\b\u0007CYCQAB\u0012\u0011\u001d\u0019Yd\u000bC\u0003\u0007{\t1\u0002U3sg&\u001cH/\u001a8dK*\u00111\fX\u0001\fa\u0016\u00148/[:uK:\u001cWMC\u0001^\u0003\u0011\t7n[1\u0004\u0001A\u0011\u0001-A\u0007\u00025\nY\u0001+\u001a:tSN$XM\\2f'\u0015\t1-[B.!\t!w-D\u0001f\u0015\u00051\u0017!B:dC2\f\u0017B\u00015f\u0005\u0019\te.\u001f*fMB\u0019!.\\8\u000e\u0003-T!\u0001\u001c/\u0002\u000b\u0005\u001cGo\u001c:\n\u00059\\'aC#yi\u0016t7/[8o\u0013\u0012\u0004\"\u0001Y\u0016\u0014\u0007-\u001a\u0017\u000f\u0005\u0002ke&\u00111o\u001b\u0002\n\u000bb$XM\\:j_:\faa]=ti\u0016lW#\u0001<\u0011\u0005)<\u0018B\u0001=l\u0005M)\u0005\u0010^3oI\u0016$\u0017i\u0019;peNK8\u000f^3n\u0003\u001d\u0019\u0018p\u001d;f[\u0002\na\u0001P5oSRtDCA8}\u0011\u0015!h\u00061\u0001w\u0003\rawnZ\u000b\u0002\u007fB!\u0011\u0011AA\u0004\u001b\t\t\u0019AC\u0002\u0002\u0006q\u000bQ!\u001a<f]RLA!!\u0003\u0002\u0004\tqAj\\4hS:<\u0017\tZ1qi\u0016\u0014\u0018a\u0006(p':\f\u0007o\u001d5piN#xN]3QYV<\u0017N\\%e+\t\ty\u0001\u0005\u0003\u0002\u0012\u0005mQBAA\n\u0015\u0011\t)\"a\u0006\u0002\t1\fgn\u001a\u0006\u0003\u00033\tAA[1wC&!\u0011QDA\n\u0005\u0019\u0019FO]5oO\u0006Abj\\*oCB\u001c\bn\u001c;Ti>\u0014X\r\u00157vO&t\u0017\n\u001a\u0011\u0002\r\r|gNZ5h+\t\t)\u0003\u0005\u0003\u0002(\u0005MRBAA\u0015\u0015\u0011\t\t#a\u000b\u000b\t\u00055\u0012qF\u0001\tif\u0004Xm]1gK*\u0011\u0011\u0011G\u0001\u0004G>l\u0017\u0002BA\u001b\u0003S\u0011aaQ8oM&<\u0017aB2p]\u001aLw\rI\u0001\u0012e\u0016\u001cwN^3ssB+'/\\5ui\u0016\u0014XCAA\u001f!\rQ\u0017qH\u0005\u0004\u0003\u0003Z'\u0001C!di>\u0014(+\u001a4\u0002%I,7m\u001c<fef\u0004VM]7jiR,'\u000f\t\u0015\u0004k\u0005\u001d\u0003\u0003BA%\u0003\u001fj!!a\u0013\u000b\u0007\u00055C,\u0001\u0006b]:|G/\u0019;j_:LA!!\u0015\u0002L\tY\u0011J\u001c;fe:\fG.\u00119j\u0003Y!WMZ1vYRTu.\u001e:oC2\u0004F.^4j]&#\u0017a\u00063fM\u0006,H\u000e^*oCB\u001c\bn\u001c;QYV<\u0017N\\%e\u0003\u0011\"WMZ1vYRLe\u000e^3s]\u0006d7\u000b^1tQ>3XM\u001d4m_^\u001cFO]1uK\u001eLXCAA.!\r\u0001\u0017QL\u0005\u0004\u0003?R&!F*uCNDwJ^3sM2|wo\u0015;sCR,w-_\u0001\tg\u0016$H/\u001b8hgV\u0011\u0011Q\r\t\u0004A\u0006\u001d\u0014bAA55\n\u0019\u0002+\u001a:tSN$XM\\2f'\u0016$H/\u001b8hg\u0006I1/\u001a;uS:<7\u000fI\u0001\u0012a2,x-\u001b8FqR,gn]5p]&#WCAA9!\u0019\t\u0019(!!\u0002\u00066\u0011\u0011Q\u000f\u0006\u0005\u0003o\nI(\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u0003w\ni(\u0001\u0006d_:\u001cWO\u001d:f]RTA!a \u0002\u0018\u0005!Q\u000f^5m\u0013\u0011\t\u0019)!\u001e\u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016\u0004\u0002\"a\"\u0002\u0016\u0006m\u0015q\u0014\b\u0005\u0003\u0013\u000b\t\nE\u0002\u0002\f\u0016l!!!$\u000b\u0007\u0005=e,\u0001\u0004=e>|GOP\u0005\u0004\u0003'+\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0018\u0006e%aA'ba*\u0019\u00111S3\u0011\t\u0005\u001d\u0015QT\u0005\u0005\u0003;\tI\n\u0005\u0003k[\u0006\u0005\u0006cAAR\u000f9\u0011\u0001\r\u0001\u0002\r!2,x-\u001b8I_2$WM]\n\b\u000f\r\f\u0018\u0011VAX!\r!\u00171V\u0005\u0004\u0003[+'a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003c\u000bYL\u0004\u0003\u00024\u0006]f\u0002BAF\u0003kK\u0011AZ\u0005\u0004\u0003s+\u0017a\u00029bG.\fw-Z\u0005\u0005\u0003{\u000byL\u0001\u0007TKJL\u0017\r\\5{C\ndWMC\u0002\u0002:\u0016\fA\"Y2u_J4\u0015m\u0019;pef,\"!!2\u0011\u000b\u0011\f9-!\u0010\n\u0007\u0005%WMA\u0005Gk:\u001cG/[8oa\u0005i\u0011m\u0019;pe\u001a\u000b7\r^8ss\u0002\n\u0001\"\u00193baR,'o]\u000b\u0003\u0003#\u0004B!a5\u0002Z6\u0011\u0011Q\u001b\u0006\u0004\u0003/T\u0016a\u00026pkJt\u0017\r\\\u0005\u0005\u00037\f)NA\u0007Fm\u0016tG/\u00113baR,'o]\u0001\nC\u0012\f\u0007\u000f^3sg\u0002\"\u0002\"!9\u0002f\u0006\u001d\u0018\u0011\u001e\t\u0004\u0003G<Q\"A\u0001\t\u000f\u0005\u0005g\u00021\u0001\u0002F\"9\u0011Q\u001a\bA\u0002\u0005E\u0007bBA\u0011\u001d\u0001\u0007\u0011QE\u0001\u0005G>\u0004\u0018\u0010\u0006\u0005\u0002b\u0006=\u0018\u0011_Az\u0011%\t\t\r\u0005I\u0001\u0002\u0004\t)\rC\u0005\u0002NB\u0001\n\u00111\u0001\u0002R\"I\u0011\u0011\u0005\t\u0011\u0002\u0003\u0007\u0011QE\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tIP\u000b\u0003\u0002F\u0006m8FAA\u007f!\u0011\tyPa\u0002\u000e\u0005\t\u0005!\u0002\u0002B\u0002\u0005\u000b\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u00055S-\u0003\u0003\u0003\n\t\u0005!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001B\bU\u0011\t\t.a?\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!Q\u0003\u0016\u0005\u0003K\tY0A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0005;\u00012\u0001\u001aB\u0010\u0013\r\u0011\t#\u001a\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005O\u0011i\u0003E\u0002e\u0005SI1Aa\u000bf\u0005\r\te.\u001f\u0005\n\u0005_1\u0012\u0011!a\u0001\u0005;\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B\u001b!\u0019\u00119D!\u0010\u0003(5\u0011!\u0011\b\u0006\u0004\u0005w)\u0017AC2pY2,7\r^5p]&!!q\bB\u001d\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\t\u0015#1\n\t\u0004I\n\u001d\u0013b\u0001B%K\n9!i\\8mK\u0006t\u0007\"\u0003B\u00181\u0005\u0005\t\u0019\u0001B\u0014\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005=!\u0011\u000b\u0005\n\u0005_I\u0012\u0011!a\u0001\u0005;\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0005;\t\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u001f\ta!Z9vC2\u001cH\u0003\u0002B#\u0005?B\u0011Ba\f\u001d\u0003\u0003\u0005\rAa\n\u0002%AdWoZ5o\u000bb$XM\\:j_:LE\rI\u0001 m\u0016\u0014\u0018NZ=K_V\u0014h.\u00197QYV<\u0017N\\\"p]\u001aLw-\u0012=jgR\u001cHC\u0002B4\u0005[\u0012\t\bE\u0002e\u0005SJ1Aa\u001bf\u0005\u0011)f.\u001b;\t\u000f\t=T\b1\u0001\u0002&\u0005a\u0001\u000f\\;hS:\u001cuN\u001c4jO\"9!1O\u001fA\u0002\u0005m\u0015AC2p]\u001aLw\rU1uQ\u0006\u0001c/\u001a:jMf\u001cf.\u00199tQ>$\b\u000b\\;hS:\u001cuN\u001c4jO\u0016C\u0018n\u001d;t)\u0019\u00119G!\u001f\u0003|!9!q\u000e A\u0002\u0005\u0015\u0002b\u0002B:}\u0001\u0007\u00111T\u0001\fC\u0012\f\u0007\u000f^3sg\u001a{'\u000f\u0006\u0003\u0002R\n\u0005\u0005b\u0002BB\u007f\u0001\u0007\u00111T\u0001\u0010U>,(O\\1m!2,x-\u001b8JIR1\u0011\u0011\u001bBD\u0005\u0013CqAa!A\u0001\u0004\tY\nC\u0004\u0003\f\u0002\u0003\r!!\n\u0002')|WO\u001d8bYBcWoZ5o\u0007>tg-[4\u0015\t\u0005E'q\u0012\u0005\b\u0005#\u000b\u0005\u0019AA\u001f\u0003IQw.\u001e:oC2\u0004F.^4j]\u0006\u001bGo\u001c:\u0002!)|WO\u001d8bY\u000e{gNZ5h\r>\u0014HCBA\u0013\u0005/\u0013I\nC\u0004\u0003\u0004\n\u0003\r!a'\t\u0013\t-%\t%AA\u0002\u0005\u0015\u0012A\u00076pkJt\u0017\r\\\"p]\u001aLwMR8sI\u0011,g-Y;mi\u0012\u0012\u0014!C2p]\u001aLwMR8s)\u0011\t)C!)\t\u000f\tEE\t1\u0001\u0002>\u0005Q!n\\;s]\u0006dgi\u001c:\u0015\r\u0005u\"q\u0015BU\u0011\u001d\u0011\u0019)\u0012a\u0001\u00037C\u0011Ba#F!\u0003\u0005\r!!\n)\u0007\u0015\u0013i\u000b\u0005\u0003\u0002J\t=\u0016\u0002\u0002BY\u0003\u0017\u0012\u0011#\u00138uKJt\u0017\r\\*uC\ndW-\u00119j\u0003QQw.\u001e:oC24uN\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005\u00012O\\1qg\"|Go\u0015;pe\u00164uN\u001d\u000b\u0007\u0003{\u0011IL!0\t\u000f\tmv\t1\u0001\u0002\u001c\u0006\u00012O\\1qg\"|G\u000f\u00157vO&t\u0017\n\u001a\u0005\n\u0005\u007f;\u0005\u0013!a\u0001\u0003K\tAc\u001d8baNDw\u000e\u001e)mk\u001eLgnQ8oM&<\u0007fA$\u0003.\u0006Q2O\\1qg\"|Go\u0015;pe\u00164uN\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005y\u0001\u000f\\;hS:Du\u000e\u001c3fe\u001a{'\u000f\u0006\u0005\u0002\"\n%'1\u001aBh\u0011\u001d\u0011\u0019(\u0013a\u0001\u00037CqA!4J\u0001\u0004\tY*\u0001\u0007gC2d'-Y2l!\u0006$\b\u000eC\u0004\u0003R&\u0003\r!!\n\u0002!\u0005$G-\u001b;j_:\fGnQ8oM&<\u0007fA%\u0003VB!!q\u001bBm\u001b\t\u0011)!\u0003\u0003\u0003\\\n\u0015!a\u0002;bS2\u0014XmY\u0001\rGJ,\u0017\r^3QYV<\u0017N\u001c\u000b\u0007\u0003{\u0011\tOa9\t\u000f\tM$\n1\u0001\u0002\u001c\"9!q\u000e&A\u0002\u0005\u0015\u0012AD2sK\u0006$X-\u00113baR,'o\u001d\u000b\u0007\u0003#\u0014IOa;\t\u000f\tM4\n1\u0001\u0002\u001c\"9!\u0011[&A\u0002\u0005\u0015\u0012!\u00049feNL7\u000f^3oG\u0016LE\r\u0006\u0003\u0002\u001c\nE\bb\u0002Bz\u0019\u0002\u0007\u0011QH\u0001\u0010a\u0016\u00148/[:uK:$\u0018i\u0019;pe\u0006\u0011\u0011\u000e\u001a\u000b\u0005\u00037\u0013I\u0010C\u0004\u0003|6\u0003\r!!\u0010\u0002\u0007I,gMA\fQYV<\u0017N\u001c%pY\u0012,'/\u0012=uK:\u001c\u0018n\u001c8JIN!ajYAP)!\u0019\u0019aa\u0002\u0004\n\r-\u0001cAB\u0003\u001d6\t1\u0006C\u0004\u0003tI\u0003\r!a'\t\u000f\t5'\u000b1\u0001\u0002\u001c\"9!\u0011\u001b*A\u0002\u0005\u0015BCBB\u0002\u0007\u001f\u0019\t\u0002C\u0004\u0003tM\u0003\r!a'\t\u000f\t57\u000b1\u0001\u0002\u001c\u0006y1M]3bi\u0016,\u0005\u0010^3og&|g\u000e\u0006\u0003\u0002\"\u000e]\u0001\"\u0002;U\u0001\u00041\u0018A\u00048v[\n,'o\u00144TY&\u001cWm]\u0001\u0016g2L7-\u001a$peB+'o]5ti\u0016t7-Z%e)\u0011\u0011iba\b\t\u000f\t5h\u000b1\u0001\u0002\u001c\u0006Y1\u000f\\5dKJ\u000bgnZ3t)\u0011\u0019)ca\u000e\u0011\r\r\u001d2QFB\u0019\u001b\t\u0019IC\u0003\u0003\u0004,\te\u0012!C5n[V$\u0018M\u00197f\u0013\u0011\u0019yc!\u000b\u0003\u0015%sG-\u001a=fIN+\u0017\u000f\u0005\u0003\u00022\u000eM\u0012\u0002BB\u001b\u0003\u007f\u0013QAU1oO\u0016Dqa!\u000fX\u0001\u0004\u0011i\"\u0001\bok6\u0014WM](g%\u0006tw-Z:\u0002\u001d\u001d,Go\u00157jG\u0016\u0014\u0016M\\4fgR!1qHB-!\u0019\u0019\tea\u0011\u0004H5\u0011\u0011QP\u0005\u0005\u0007\u000b\niH\u0001\u0003MSN$\b\u0003CB%\u0007\u001f\u001a\u0019fa\u0015\u000e\u0005\r-#bAB'9\u0006!!.\u00199j\u0013\u0011\u0019\tfa\u0013\u0003\tA\u000b\u0017N\u001d\t\u0005\u0003#\u0019)&\u0003\u0003\u0004X\u0005M!aB%oi\u0016<WM\u001d\u0005\b\u0007sA\u0006\u0019\u0001B\u000f!\rQ7QL\u0005\u0004\u0007?Z'aE#yi\u0016t7/[8o\u0013\u0012\u0004&o\u001c<jI\u0016\u0014H#A0\u0002\u0007\u001d,G\u000fF\u0002p\u0007OBa\u0001^\u0002A\u0002\r%\u0004c\u00016\u0004l%\u00191QN6\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\u001c\u000b\u0004_\u000eE\u0004B\u0002;\u0005\u0001\u0004\u0019\u0019\bE\u0002k\u0007kJ1aa\u001el\u0005i\u0019E.Y:tS\u000e\f5\r^8s'f\u001cH/Z7Qe>4\u0018\u000eZ3s)\ry71\u0010\u0005\u0006i\u0016\u0001\rA^\u0001\u0007Y>|7.\u001e9\u0016\u0003}\u000bA\u0002\u00157vO&t\u0007j\u001c7eKJ\u00042!a9\u001f'\u0015q2qQBJ!1\u0019Iia$\u0002F\u0006E\u0017QEAq\u001b\t\u0019YIC\u0002\u0004\u000e\u0016\fqA];oi&lW-\u0003\u0003\u0004\u0012\u000e-%!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ogA!1QSBN\u001b\t\u00199J\u0003\u0003\u0004\u001a\u0006]\u0011AA5p\u0013\u0011\tila&\u0015\u0005\r\r\u0015!B1qa2LH\u0003CAq\u0007G\u001b)ka*\t\u000f\u0005\u0005\u0017\u00051\u0001\u0002F\"9\u0011QZ\u0011A\u0002\u0005E\u0007bBA\u0011C\u0001\u0007\u0011QE\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0019ik!/\u0011\u000b\u0011\u001cyka-\n\u0007\rEVM\u0001\u0004PaRLwN\u001c\t\nI\u000eU\u0016QYAi\u0003KI1aa.f\u0005\u0019!V\u000f\u001d7fg!I11\u0018\u0012\u0002\u0002\u0003\u0007\u0011\u0011]\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCABa!\u0011\t\tba1\n\t\r\u0015\u00171\u0003\u0002\u0007\u001f\nTWm\u0019;\u00023){WO\u001d8bY\u001a\u000bG\u000e\u001c2bG.\u001cuN\u001c4jOB\u000bG\u000f[\u0001\u001b\u0015>,(O\\1m\r\u0006dGNY1dW\u000e{gNZ5h!\u0006$\b\u000eI\u0001 ':\f\u0007o\u001d5piN#xN]3GC2d'-Y2l\u0007>tg-[4QCRD\u0017\u0001I*oCB\u001c\bn\u001c;Ti>\u0014XMR1mY\n\f7m[\"p]\u001aLw\rU1uQ\u0002\n\u0001D^3sS\u001aL\b\u000b\\;hS:\u001cuN\u001c4jO\u0016C\u0018n\u001d;t)!\u00119ga5\u0004V\u000ee\u0007bBA\u0011Q\u0001\u0007\u0011Q\u0005\u0005\b\u0007/D\u0003\u0019AAN\u0003!\u0001H.^4j]&#\u0007bBBnQ\u0001\u0007\u00111T\u0001\u000ba2,x-\u001b8UsB,\u0007f\u0001\u0015\u0002H\u0005Yb/\u001a:jMf\u0004F.^4j]\u000e{gNZ5h\u0013N$UMZ5oK\u0012$bAa\u001a\u0004d\u000e\u0015\bbBBlS\u0001\u0007\u00111\u0014\u0005\b\u00077L\u0003\u0019AANQ\rI\u0013qI\u0001\bSN,U\u000e\u001d;z)\u0011\u0011)e!<\t\u000f\r=(\u00061\u0001\u0002\u001c\u0006!A/\u001a=u\u0001")
public class Persistence
implements Extension {
    private String defaultJournalPluginId;
    private String defaultSnapshotPluginId;
    private StashOverflowStrategy defaultInternalStashOverflowStrategy;
    private final ExtendedActorSystem system;
    private String NoSnapshotStorePluginId;
    private final Config config;
    @InternalApi
    private final ActorRef recoveryPermitter;
    private final PersistenceSettings settings;
    private final AtomicReference<Map<String, ExtensionId<PluginHolder>>> pluginExtensionId;
    private volatile byte bitmap$0;

    public static String SnapshotStoreFallbackConfigPath() {
        return Persistence$.MODULE$.SnapshotStoreFallbackConfigPath();
    }

    public static String JournalFallbackConfigPath() {
        return Persistence$.MODULE$.JournalFallbackConfigPath();
    }

    public static Persistence$ lookup() {
        return Persistence$.MODULE$.lookup();
    }

    public static Persistence createExtension(ExtendedActorSystem system) {
        return Persistence$.MODULE$.createExtension(system);
    }

    public static Persistence get(ClassicActorSystemProvider system) {
        return Persistence$.MODULE$.get(system);
    }

    public static Persistence get(ActorSystem system) {
        return Persistence$.MODULE$.get(system);
    }

    public static Extension apply(ClassicActorSystemProvider system) {
        return Persistence$.MODULE$.apply(system);
    }

    public static Extension apply(ActorSystem system) {
        return Persistence$.MODULE$.apply(system);
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public LoggingAdapter akka$persistence$Persistence$$log() {
        return Logging$.MODULE$.apply(this.system(), Persistence.class, LogSource$.MODULE$.fromAnyClass());
    }

    private String NoSnapshotStorePluginId() {
        return this.NoSnapshotStorePluginId;
    }

    private Config config() {
        return this.config;
    }

    public ActorRef recoveryPermitter() {
        return this.recoveryPermitter;
    }

    /*
     * WARNING - void declaration
     */
    private String defaultJournalPluginId$lzycompute() {
        Persistence persistence = this;
        synchronized (persistence) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var2_2;
                String configPath = this.config().getString("journal.plugin");
                Persistence$.MODULE$.verifyPluginConfigIsDefined(configPath, "Default journal");
                this.verifyJournalPluginConfigExists(ConfigFactory.empty(), configPath);
                this.defaultJournalPluginId = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.defaultJournalPluginId;
    }

    private String defaultJournalPluginId() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.defaultJournalPluginId$lzycompute() : this.defaultJournalPluginId;
    }

    /*
     * WARNING - void declaration
     */
    private String defaultSnapshotPluginId$lzycompute() {
        Persistence persistence = this;
        synchronized (persistence) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                String string;
                String configPath = this.config().getString("snapshot-store.plugin");
                if (Persistence$.MODULE$.akka$persistence$Persistence$$isEmpty(configPath)) {
                    this.akka$persistence$Persistence$$log().warning("No default snapshot store configured! To configure a default snapshot-store plugin set the `akka.persistence.snapshot-store.plugin` key. For details see 'reference.conf'");
                    string = this.NoSnapshotStorePluginId();
                } else {
                    void var2_2;
                    this.verifySnapshotPluginConfigExists(ConfigFactory.empty(), configPath);
                    string = var2_2;
                }
                this.defaultSnapshotPluginId = string;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        this.NoSnapshotStorePluginId = null;
        return this.defaultSnapshotPluginId;
    }

    private String defaultSnapshotPluginId() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.defaultSnapshotPluginId$lzycompute() : this.defaultSnapshotPluginId;
    }

    private StashOverflowStrategy defaultInternalStashOverflowStrategy$lzycompute() {
        Persistence persistence = this;
        synchronized (persistence) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.defaultInternalStashOverflowStrategy = (StashOverflowStrategy)this.system().dynamicAccess().createInstanceFor(this.config().getString("internal-stash-overflow-strategy"), Collections$EmptyImmutableSeq$.MODULE$, ClassTag$.MODULE$.apply(StashOverflowStrategyConfigurator.class)).map((Function1 & Serializable)x$1 -> x$1.create(this.system().settings().config())).get();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.defaultInternalStashOverflowStrategy;
    }

    public StashOverflowStrategy defaultInternalStashOverflowStrategy() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.defaultInternalStashOverflowStrategy$lzycompute() : this.defaultInternalStashOverflowStrategy;
    }

    public PersistenceSettings settings() {
        return this.settings;
    }

    private AtomicReference<Map<String, ExtensionId<PluginHolder>>> pluginExtensionId() {
        return this.pluginExtensionId;
    }

    private void verifyJournalPluginConfigExists(Config pluginConfig, String configPath) {
        Persistence$.MODULE$.verifyPluginConfigExists(pluginConfig.withFallback((ConfigMergeable)this.system().settings().config()), configPath, "Journal");
    }

    private void verifySnapshotPluginConfigExists(Config pluginConfig, String configPath) {
        Persistence$.MODULE$.verifyPluginConfigExists(pluginConfig.withFallback((ConfigMergeable)this.system().settings().config()), configPath, "Snapshot store");
    }

    public final EventAdapters adaptersFor(String journalPluginId) {
        return this.adaptersFor(journalPluginId, ConfigFactory.empty());
    }

    public final EventAdapters adaptersFor(String journalPluginId, Config journalPluginConfig) {
        String configPath = Persistence$.MODULE$.akka$persistence$Persistence$$isEmpty(journalPluginId) ? this.defaultJournalPluginId() : journalPluginId;
        this.verifyJournalPluginConfigExists(journalPluginConfig, configPath);
        return this.pluginHolderFor(configPath, Persistence$.MODULE$.JournalFallbackConfigPath(), journalPluginConfig).adapters();
    }

    public final EventAdapters adaptersFor(ActorRef journalPluginActor) {
        EventAdapters eventAdapters;
        Option option = ((MapOps)this.pluginExtensionId().get()).values().collectFirst((PartialFunction)new Serializable(this, journalPluginActor){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ Persistence $outer;
            private final ActorRef journalPluginActor$1;

            public final <A1 extends ExtensionId<PluginHolder>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                ActorRef actorRef2 = A1.apply(this.$outer.system()).actor();
                ActorRef actorRef3 = this.journalPluginActor$1;
                Object object = !(actorRef2 != null ? !((Object)actorRef2).equals(actorRef3) : actorRef3 != null) ? A1.apply(this.$outer.system()).adapters() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(ExtensionId<PluginHolder> x1) {
                ExtensionId<PluginHolder> extensionId = x1;
                ActorRef actorRef2 = extensionId.apply(this.$outer.system()).actor();
                ActorRef actorRef3 = this.journalPluginActor$1;
                boolean bl = !(actorRef2 != null ? !((Object)actorRef2).equals(actorRef3) : actorRef3 != null);
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.journalPluginActor$1 = journalPluginActor$1;
            }
        });
        if (option instanceof Some) {
            Some some = (Some)option;
            EventAdapters adapters = (EventAdapters)some.value();
            eventAdapters = adapters;
        } else {
            eventAdapters = IdentityEventAdapters$.MODULE$;
        }
        return eventAdapters;
    }

    public final Config journalConfigFor(String journalPluginId, Config journalPluginConfig) {
        String configPath = Persistence$.MODULE$.akka$persistence$Persistence$$isEmpty(journalPluginId) ? this.defaultJournalPluginId() : journalPluginId;
        this.verifyJournalPluginConfigExists(journalPluginConfig, configPath);
        return this.pluginHolderFor(configPath, Persistence$.MODULE$.JournalFallbackConfigPath(), journalPluginConfig).config();
    }

    public final Config journalConfigFor$default$2() {
        return ConfigFactory.empty();
    }

    public final Config configFor(ActorRef journalPluginActor) {
        Config conf;
        Option option = ((MapOps)this.pluginExtensionId().get()).values().collectFirst((PartialFunction)new Serializable(this, journalPluginActor){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ Persistence $outer;
            private final ActorRef journalPluginActor$2;

            public final <A1 extends ExtensionId<PluginHolder>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                ActorRef actorRef2 = A1.apply(this.$outer.system()).actor();
                ActorRef actorRef3 = this.journalPluginActor$2;
                Object object = !(actorRef2 != null ? !((Object)actorRef2).equals(actorRef3) : actorRef3 != null) ? A1.apply(this.$outer.system()).config() : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(ExtensionId<PluginHolder> x1) {
                ExtensionId<PluginHolder> extensionId = x1;
                ActorRef actorRef2 = extensionId.apply(this.$outer.system()).actor();
                ActorRef actorRef3 = this.journalPluginActor$2;
                boolean bl = !(actorRef2 != null ? !((Object)actorRef2).equals(actorRef3) : actorRef3 != null);
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.journalPluginActor$2 = journalPluginActor$2;
            }
        });
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalArgumentException(new StringBuilder(21).append("Unknown plugin actor ").append(journalPluginActor).toString());
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        Config config = conf = (Config)some.value();
        return config;
    }

    @InternalStableApi
    public final ActorRef journalFor(String journalPluginId, Config journalPluginConfig) {
        String configPath = Persistence$.MODULE$.akka$persistence$Persistence$$isEmpty(journalPluginId) ? this.defaultJournalPluginId() : journalPluginId;
        this.verifyJournalPluginConfigExists(journalPluginConfig, configPath);
        return this.pluginHolderFor(configPath, Persistence$.MODULE$.JournalFallbackConfigPath(), journalPluginConfig).actor();
    }

    public final Config journalFor$default$2() {
        return ConfigFactory.empty();
    }

    @InternalStableApi
    public final ActorRef snapshotStoreFor(String snapshotPluginId, Config snapshotPluginConfig) {
        String configPath = Persistence$.MODULE$.akka$persistence$Persistence$$isEmpty(snapshotPluginId) ? this.defaultSnapshotPluginId() : snapshotPluginId;
        this.verifySnapshotPluginConfigExists(snapshotPluginConfig, configPath);
        return this.pluginHolderFor(configPath, Persistence$.MODULE$.SnapshotStoreFallbackConfigPath(), snapshotPluginConfig).actor();
    }

    public final Config snapshotStoreFor$default$2() {
        return ConfigFactory.empty();
    }

    private PluginHolder pluginHolderFor(String configPath, String fallbackPath, Config additionalConfig) {
        Option option;
        block1: {
            while (true) {
                Map<String, ExtensionId<PluginHolder>> extensionIdMap;
                if ((option = (extensionIdMap = this.pluginExtensionId().get()).get((Object)configPath)) instanceof Some) break block1;
                if (!None$.MODULE$.equals(option)) break;
                PluginHolderExtensionId extensionId = new PluginHolderExtensionId(this, configPath, fallbackPath, additionalConfig);
                this.pluginExtensionId().compareAndSet(extensionIdMap, (Map<String, ExtensionId<PluginHolder>>)extensionIdMap.updated((Object)configPath, (Object)extensionId));
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        ExtensionId extensionId = (ExtensionId)some.value();
        PluginHolder pluginHolder = (PluginHolder)extensionId.apply(this.system());
        return pluginHolder;
    }

    public ActorRef akka$persistence$Persistence$$createPlugin(String configPath, Config pluginConfig) {
        List list;
        String pluginActorName = configPath;
        String pluginClassName = pluginConfig.getString("class");
        if (Persistence$.MODULE$.akka$persistence$Persistence$$isEmpty(pluginClassName)) {
            throw new IllegalArgumentException(new StringBuilder(61).append("Plugin class name must be defined in config property [").append(configPath).append(".class]").toString());
        }
        this.akka$persistence$Persistence$$log().debug(new StringBuilder(16).append("Create plugin: ").append(pluginActorName).append(" ").append(pluginClassName).toString());
        Class pluginClass = (Class)this.system().dynamicAccess().getClassFor(pluginClassName, ClassTag$.MODULE$.Any()).get();
        String pluginDispatcherId = pluginConfig.getString("plugin-dispatcher");
        try {
            Reflect$.MODULE$.findConstructor(pluginClass, (scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{pluginConfig, configPath}))));
            list = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{pluginConfig, configPath}));
        }
        catch (Throwable throwable) {
            Nil$ nil$;
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                try {
                    Reflect$.MODULE$.findConstructor(pluginClass, (scala.collection.immutable.Seq<Object>)((scala.collection.immutable.Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Config[]{pluginConfig}))));
                    nil$ = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Config[]{pluginConfig}));
                }
                catch (Throwable throwable3) {
                    Option option2;
                    Throwable throwable4 = throwable3;
                    if (throwable4 == null || (option2 = NonFatal$.MODULE$.unapply(throwable4)).isEmpty()) {
                        throw throwable3;
                    }
                    Nil$ nil$2 = package$.MODULE$.Nil();
                    nil$ = nil$2;
                }
            } else {
                throw throwable;
            }
            Nil$ nil$3 = nil$;
            list = nil$3;
        }
        List pluginActorArgs = list;
        String x$1 = pluginDispatcherId;
        String x$2 = Deploy$.MODULE$.apply$default$1();
        Config x$3 = Deploy$.MODULE$.apply$default$2();
        RouterConfig x$4 = Deploy$.MODULE$.apply$default$3();
        Scope x$5 = Deploy$.MODULE$.apply$default$4();
        String x$6 = Deploy$.MODULE$.apply$default$6();
        Props pluginActorProps = new Props(Deploy$.MODULE$.apply(x$2, x$3, x$4, x$5, x$1, x$6), pluginClass, (scala.collection.immutable.Seq<Object>)pluginActorArgs);
        return this.system().systemActorOf(pluginActorProps, pluginActorName);
    }

    public EventAdapters akka$persistence$Persistence$$createAdapters(String configPath, Config additionalConfig) {
        Config pluginConfig = additionalConfig.withFallback((ConfigMergeable)this.system().settings().config()).getConfig(configPath);
        return EventAdapters$.MODULE$.apply(this.system(), pluginConfig);
    }

    public String persistenceId(ActorRef persistentActor) {
        return this.id(persistentActor);
    }

    private String id(ActorRef ref) {
        return ref.path().toStringWithoutAddress();
    }

    public final int numberOfSlices() {
        return 1024;
    }

    public final int sliceForPersistenceId(String persistenceId) {
        return scala.math.package$.MODULE$.abs(persistenceId.hashCode() % this.numberOfSlices());
    }

    public final IndexedSeq<Range> sliceRanges(int numberOfRanges) {
        int rangeSize = this.numberOfSlices() / numberOfRanges;
        Predef$.MODULE$.require(numberOfRanges * rangeSize == this.numberOfSlices(), (Function0 & Serializable)() -> new StringBuilder(70).append("numberOfRanges [").append(numberOfRanges).append("] must be a whole number divisor of numberOfSlices [").append(this.numberOfSlices()).append("].").toString());
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numberOfRanges).map((Function1 & Serializable)i -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(BoxesRunTime.unboxToInt((Object)i) * rangeSize), BoxesRunTime.unboxToInt((Object)i) * rangeSize + rangeSize)).toVector();
    }

    public final java.util.List<Pair<Integer, Integer>> getSliceRanges(int numberOfRanges) {
        return package$JavaConverters$.MODULE$.SeqHasAsJava((Seq)this.sliceRanges(numberOfRanges).map((Function1 & Serializable)range -> new Pair<Integer, Integer>(range.min((Ordering)Ordering.Int$.MODULE$), range.max((Ordering)Ordering.Int$.MODULE$)))).asJava();
    }

    public Persistence(ExtendedActorSystem system) {
        this.system = system;
        this.NoSnapshotStorePluginId = "akka.persistence.no-snapshot-store";
        this.config = system.settings().config().getConfig("akka.persistence");
        int maxPermits = this.config().getInt("max-concurrent-recoveries");
        this.recoveryPermitter = system.systemActorOf(RecoveryPermitter$.MODULE$.props(maxPermits), "recoveryPermitter");
        this.settings = new PersistenceSettings(this.config());
        this.pluginExtensionId = new AtomicReference<Map>(Predef$.MODULE$.Map().empty());
        this.config().getStringList("journal.auto-start-journals").forEach(new Consumer<String>(this){
            private final /* synthetic */ Persistence $outer;

            public Consumer<String> andThen(Consumer<? super String> x$1) {
                return Consumer.super.andThen(x$1);
            }

            public void accept(String id) {
                this.$outer.akka$persistence$Persistence$$log().info(new StringBuilder(31).append("Auto-starting journal plugin `").append(id).append("`").toString());
                this.$outer.journalFor(id, this.$outer.journalFor$default$2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.config().getStringList("snapshot-store.auto-start-snapshot-stores").forEach(new Consumer<String>(this){
            private final /* synthetic */ Persistence $outer;

            public Consumer<String> andThen(Consumer<? super String> x$1) {
                return Consumer.super.andThen(x$1);
            }

            public void accept(String id) {
                this.$outer.akka$persistence$Persistence$$log().info(new StringBuilder(31).append("Auto-starting snapshot store `").append(id).append("`").toString());
                this.$outer.snapshotStoreFor(id, this.$outer.snapshotStoreFor$default$2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static class PluginHolder
    implements Extension,
    Product,
    Serializable {
        private ActorRef actor;
        private final Function0<ActorRef> actorFactory;
        private final EventAdapters adapters;
        private final Config config;
        private volatile boolean bitmap$0;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public Function0<ActorRef> actorFactory() {
            return this.actorFactory;
        }

        public EventAdapters adapters() {
            return this.adapters;
        }

        public Config config() {
            return this.config;
        }

        private ActorRef actor$lzycompute() {
            PluginHolder pluginHolder = this;
            synchronized (pluginHolder) {
                if (!this.bitmap$0) {
                    this.actor = (ActorRef)this.actorFactory().apply();
                    this.bitmap$0 = true;
                }
            }
            return this.actor;
        }

        public ActorRef actor() {
            return !this.bitmap$0 ? this.actor$lzycompute() : this.actor;
        }

        public PluginHolder copy(Function0<ActorRef> actorFactory, EventAdapters adapters, Config config) {
            return new PluginHolder(actorFactory, adapters, config);
        }

        public Function0<ActorRef> copy$default$1() {
            return this.actorFactory();
        }

        public EventAdapters copy$default$2() {
            return this.adapters();
        }

        public Config copy$default$3() {
            return this.config();
        }

        public String productPrefix() {
            return "PluginHolder";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.actorFactory();
                    break;
                }
                case 1: {
                    object = this.adapters();
                    break;
                }
                case 2: {
                    object = this.config();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof PluginHolder;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "actorFactory";
                    break;
                }
                case 1: {
                    string = "adapters";
                    break;
                }
                case 2: {
                    string = "config";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof PluginHolder)) return false;
            boolean bl = true;
            if (!bl) return false;
            PluginHolder pluginHolder = (PluginHolder)x$1;
            Function0<ActorRef> function0 = this.actorFactory();
            Function0<ActorRef> function02 = pluginHolder.actorFactory();
            if (function0 == null) {
                if (function02 != null) {
                    return false;
                }
            } else if (!function0.equals(function02)) return false;
            EventAdapters eventAdapters = this.adapters();
            EventAdapters eventAdapters2 = pluginHolder.adapters();
            if (eventAdapters == null) {
                if (eventAdapters2 != null) {
                    return false;
                }
            } else if (!eventAdapters.equals(eventAdapters2)) return false;
            Config config = this.config();
            Config config2 = pluginHolder.config();
            if (config == null) {
                if (config2 != null) {
                    return false;
                }
            } else if (!config.equals(config2)) return false;
            if (!pluginHolder.canEqual(this)) return false;
            return true;
        }

        public PluginHolder(Function0<ActorRef> actorFactory, EventAdapters adapters, Config config) {
            this.actorFactory = actorFactory;
            this.adapters = adapters;
            this.config = config;
            Product.$init$((Product)this);
        }
    }

    private class PluginHolderExtensionId
    implements ExtensionId<PluginHolder> {
        private final String configPath;
        private final String fallbackPath;
        private final Config additionalConfig;
        public final /* synthetic */ Persistence $outer;

        @Override
        public Extension apply(ActorSystem system) {
            return ExtensionId.apply$((ExtensionId)this, system);
        }

        @Override
        public Extension apply(ClassicActorSystemProvider system) {
            return ExtensionId.apply$((ExtensionId)this, system);
        }

        @Override
        public Extension get(ActorSystem system) {
            return ExtensionId.get$((ExtensionId)this, system);
        }

        @Override
        public Extension get(ClassicActorSystemProvider system) {
            return ExtensionId.get$((ExtensionId)this, system);
        }

        @Override
        public final int hashCode() {
            return ExtensionId.hashCode$(this);
        }

        @Override
        public final boolean equals(Object other) {
            return ExtensionId.equals$(this, other);
        }

        @Override
        public PluginHolder createExtension(ExtendedActorSystem system) {
            Config mergedConfig = this.additionalConfig.withFallback((ConfigMergeable)system.settings().config());
            Predef$.MODULE$.require(!Persistence$.MODULE$.akka$persistence$Persistence$$isEmpty(this.configPath) && mergedConfig.hasPath(this.configPath), (Function0 & Serializable)() -> new StringBuilder(62).append("'reference.conf' is missing persistence plugin config path: '").append($this.configPath).append("'").toString());
            Config config = mergedConfig.getConfig(this.configPath).withFallback((ConfigMergeable)mergedConfig.getConfig(this.fallbackPath));
            Function0 & Serializable pluginActorFactory = (Function0 & Serializable)() -> this.akka$persistence$Persistence$PluginHolderExtensionId$$$outer().akka$persistence$Persistence$$createPlugin($this.configPath, config);
            EventAdapters adapters = this.akka$persistence$Persistence$PluginHolderExtensionId$$$outer().akka$persistence$Persistence$$createAdapters(this.configPath, mergedConfig);
            return new PluginHolder((Function0<ActorRef>)pluginActorFactory, adapters, config);
        }

        public /* synthetic */ Persistence akka$persistence$Persistence$PluginHolderExtensionId$$$outer() {
            return this.$outer;
        }

        public PluginHolderExtensionId(Persistence $outer, String configPath, String fallbackPath, Config additionalConfig) {
            this.configPath = configPath;
            this.fallbackPath = fallbackPath;
            this.additionalConfig = additionalConfig;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            ExtensionId.$init$(this);
        }

        public PluginHolderExtensionId(Persistence $outer, String configPath, String fallbackPath) {
            this($outer, configPath, fallbackPath, ConfigFactory.empty());
        }
    }
}

