/*
 * Decompiled with CFR 0.152.
 */
package akka.actor;

import akka.actor.ActorContext;
import akka.actor.ActorIdentity;
import akka.actor.ActorNotFound;
import akka.actor.ActorPath;
import akka.actor.ActorRef;
import akka.actor.ActorRefWithCell;
import akka.actor.ActorSelection$;
import akka.actor.ActorSelectionMessage;
import akka.actor.Identify;
import akka.actor.InternalActorRef;
import akka.actor.ScalaActorSelection;
import akka.actor.SelectionPathElement;
import akka.dispatch.ExecutionContexts$;
import akka.pattern.AskableActorSelection$;
import akka.pattern.package$;
import akka.routing.MurmurHash$;
import akka.util.JavaDurationConverters$;
import akka.util.JavaDurationConverters$JavaDurationOps$;
import akka.util.Timeout;
import akka.util.Timeout$;
import java.io.Serializable;
import java.time.Duration;
import java.util.concurrent.CompletionStage;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.immutable.IndexedSeq;
import scala.compat.java8.FutureConverters$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005egaB\r\u001b\u0003\u0003y\u0012\u0011\u000e\u0005\u0006e\u0001!\ta\r\u0005\tm\u0001\u0011\rQ\"\u0005\u001do!91\b\u0001b\u0001\u000e#a\u0004\"\u0002%\u0001\t\u0003I\u0005\"\u0002+\u0001\t\u0003)\u0006\"\u00020\u0001\t\u0003y\u0006\"\u00020\u0001\t\u0003y\u0007\"B<\u0001\t\u0003A\bBB<\u0001\t\u0003\t9\u0002\u0003\u0004_\u0001\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003[\u0001A\u0011IA\u0018\u0011\u001d\t\t\u0005\u0001C\u0001\u0003\u0007Bq!a\u0013\u0001\t\u0003\ti\u0005C\u0004\u0002P\u0001!\t!!\u0014\t\u000f\u0005E\u0003\u0001\"\u0011\u0002T!Q\u0011q\f\u0001\t\u0006\u0004%\t%!\u0019\b\u000f\u0005\u0005%\u0004#\u0001\u0002\u0004\u001a1\u0011D\u0007E\u0001\u0003\u000bCaA\r\n\u0005\u0002\u0005E\u0005bBAJ%\u0011\r\u0011Q\u0013\u0005\b\u00037\u0013B\u0011AAO\u0011\u001d\tYJ\u0005C\u0001\u0003KC\u0001\"a-\u0013\t\u0003a\u0012Q\u0017\u0005\n\u0003\u0013\u0014\u0012\u0011!C\u0005\u0003\u0017\u0014a\"Q2u_J\u001cV\r\\3di&|gN\u0003\u0002\u001c9\u0005)\u0011m\u0019;pe*\tQ$\u0001\u0003bW.\f7\u0001A\n\u0004\u0001\u00012\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#AB!osJ+g\r\u0005\u0002(_9\u0011\u0001&\f\b\u0003S1j\u0011A\u000b\u0006\u0003Wy\ta\u0001\u0010:p_Rt\u0014\"A\u0012\n\u00059\u0012\u0013a\u00029bG.\fw-Z\u0005\u0003aE\u0012AbU3sS\u0006d\u0017N_1cY\u0016T!A\f\u0012\u0002\rqJg.\u001b;?)\u0005!\u0004CA\u001b\u0001\u001b\u0005Q\u0012AB1oG\"|'/F\u00019!\t)\u0014(\u0003\u0002;5\tA\u0011i\u0019;peJ+g-\u0001\u0003qCRDW#A\u001f\u0011\u0007y\u001aU)D\u0001@\u0015\t\u0001\u0015)A\u0005j[6,H/\u00192mK*\u0011!II\u0001\u000bG>dG.Z2uS>t\u0017B\u0001#@\u0005)Ie\u000eZ3yK\u0012\u001cV-\u001d\t\u0003k\u0019K!a\u0012\u000e\u0003)M+G.Z2uS>t\u0007+\u0019;i\u000b2,W.\u001a8u\u0003\u0011!X\r\u001c7\u0015\u0007)k%\u000b\u0005\u0002\"\u0017&\u0011AJ\t\u0002\u0005+:LG\u000fC\u0003O\t\u0001\u0007q*A\u0002ng\u001e\u0004\"!\t)\n\u0005E\u0013#aA!os\")1\u000b\u0002a\u0001q\u000511/\u001a8eKJ\fqAZ8so\u0006\u0014H\r\u0006\u0002W9R\u0011!j\u0016\u0005\u00061\u0016\u0001\u001d!W\u0001\bG>tG/\u001a=u!\t)$,\u0003\u0002\\5\ta\u0011i\u0019;pe\u000e{g\u000e^3yi\")Q,\u0002a\u0001\u001f\u00069Q.Z:tC\u001e,\u0017A\u0003:fg>dg/Z(oKR\t\u0001\r\u0006\u0002bOB\u0019!-\u001a\u001d\u000e\u0003\rT!\u0001\u001a\u0012\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002gG\n1a)\u001e;ve\u0016DQ\u0001\u001b\u0004A\u0004%\fq\u0001^5nK>,H\u000f\u0005\u0002k[6\t1N\u0003\u0002m9\u0005!Q\u000f^5m\u0013\tq7NA\u0004US6,w.\u001e;\u0015\u0005\u0005\u0004\b\"\u00025\b\u0001\u0004\t\bC\u0001:v\u001b\u0005\u0019(B\u0001;d\u0003!!WO]1uS>t\u0017B\u0001<t\u000591\u0015N\\5uK\u0012+(/\u0019;j_:\fAB]3t_24Xm\u00148f\u0007N#2!_A\u0002!\rQx\u0010O\u0007\u0002w*\u0011A\r \u0006\u0003YvT\u0011A`\u0001\u0005U\u00064\u0018-C\u0002\u0002\u0002m\u0014qbQ8na2,G/[8o'R\fw-\u001a\u0005\u0006Q\"\u0001\r!\u001d\u0015\u000b\u0011\u0005\u001dQ,!\u0004\u0002\u0012\u0005M\u0001cA\u0011\u0002\n%\u0019\u00111\u0002\u0012\u0003\u0015\u0011,\u0007O]3dCR,G-\t\u0002\u0002\u0010\u0005qUk]3!i\",\u0007e\u001c<fe2|\u0017\rZ3eA5,G\u000f[8eAI,7o\u001c7wK>sW\rI<iS\u000eD\u0007%Y2dKB$8\u000f\t6bm\u0006tC/[7f]\u0011+(/\u0019;j_:\u0004\u0013N\\:uK\u0006$g&A\u0003tS:\u001cW-\t\u0002\u0002\u0016\u00051!GL\u001b/eA\"2!_A\r\u0011\u0019A\u0017\u00021\u0001\u0002\u001cA!\u0011QDA\u0012\u001b\t\tyBC\u0002\u0002\"u\fA\u0001^5nK&!\u0011QEA\u0010\u0005!!UO]1uS>t\u0007FC\u0005\u0002\bu\u000bi!!\u0005\u0002\u0014Q\u0019\u00110a\u000b\t\r!T\u0001\u0019AA\u000e\u0003!!xn\u0015;sS:<GCAA\u0019!\u0011\t\u0019$a\u000f\u000f\t\u0005U\u0012q\u0007\t\u0003S\tJ1!!\u000f#\u0003\u0019\u0001&/\u001a3fM&!\u0011QHA \u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\b\u0012\u0002\u0015\u0005t7\r[8s!\u0006$\b.\u0006\u0002\u0002FA\u0019Q'a\u0012\n\u0007\u0005%#DA\u0005BGR|'\u000fU1uQ\u0006Q\u0001/\u0019;i'R\u0014\u0018N\\4\u0016\u0005\u0005E\u0012!\u0006;p'\u0016\u0014\u0018.\u00197ju\u0006$\u0018n\u001c8G_Jl\u0017\r^\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005U\u00131\f\t\u0004C\u0005]\u0013bAA-E\t9!i\\8mK\u0006t\u0007BBA/\u001f\u0001\u0007q*A\u0002pE*\f\u0001\u0002[1tQ\u000e{G-Z\u000b\u0003\u0003G\u00022!IA3\u0013\r\t9G\t\u0002\u0004\u0013:$(#BA6i\u0005=dABA7\u0001\u0001\tIG\u0001\u0007=e\u00164\u0017N\\3nK:$h\bE\u00026\u0003cJ1!a\u001d\u001b\u0005M\u00196-\u00197b\u0003\u000e$xN]*fY\u0016\u001cG/[8oQ\u001d\u0001\u0011qOA?\u0003\u007f\u00022!IA=\u0013\r\tYH\t\u0002\u0011'\u0016\u0014\u0018.\u00197WKJ\u001c\u0018n\u001c8V\u0013\u0012\u000bQA^1mk\u0016t\u0012!A\u0001\u000f\u0003\u000e$xN]*fY\u0016\u001cG/[8o!\t)$c\u0005\u0003\u0013A\u0005\u001d\u0005\u0003BAE\u0003\u001fk!!a#\u000b\u0007\u00055U0\u0001\u0002j_&\u0019\u0001'a#\u0015\u0005\u0005\r\u0015a\u0002;p'\u000e\fG.\u0019\u000b\u0005\u0003_\n9\n\u0003\u0004\u0002\u001aR\u0001\r\u0001N\u0001\u0004g\u0016d\u0017!B1qa2LH#\u0002\u001b\u0002 \u0006\r\u0006BBAQ+\u0001\u0007\u0001(A\u0005b]\u000eDwN\u001d*fM\"11(\u0006a\u0001\u0003c!R\u0001NAT\u0003SCa!!)\u0017\u0001\u0004A\u0004bBAV-\u0001\u0007\u0011QV\u0001\tK2,W.\u001a8ugB)q%a,\u00022%\u0019\u0011\u0011W\u0019\u0003\u0011%#XM]1cY\u0016\f\u0001\u0003Z3mSZ,'oU3mK\u000e$\u0018n\u001c8\u0015\u000f)\u000b9,a0\u0002B\"1ag\u0006a\u0001\u0003s\u00032!NA^\u0013\r\tiL\u0007\u0002\u0011\u0013:$XM\u001d8bY\u0006\u001bGo\u001c:SK\u001aDQaU\fA\u0002aBq!!'\u0018\u0001\u0004\t\u0019\rE\u00026\u0003\u000bL1!a2\u001b\u0005U\t5\r^8s'\u0016dWm\u0019;j_:lUm]:bO\u0016\fAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!!4\u0011\t\u0005=\u0017Q[\u0007\u0003\u0003#T1!a5~\u0003\u0011a\u0017M\\4\n\t\u0005]\u0017\u0011\u001b\u0002\u0007\u001f\nTWm\u0019;")
public abstract class ActorSelection
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int hashCode;
    private volatile boolean bitmap$0;

    public static ActorSelection apply(ActorRef anchorRef, Iterable<String> elements) {
        return ActorSelection$.MODULE$.apply(anchorRef, elements);
    }

    public static ActorSelection apply(ActorRef anchorRef, String path) {
        return ActorSelection$.MODULE$.apply(anchorRef, path);
    }

    public static ScalaActorSelection toScala(ActorSelection sel) {
        return ActorSelection$.MODULE$.toScala(sel);
    }

    public abstract ActorRef anchor();

    public abstract IndexedSeq<SelectionPathElement> path();

    public void tell(Object msg, ActorRef sender) {
        ActorSelection$.MODULE$.deliverSelection((InternalActorRef)this.anchor(), sender, new ActorSelectionMessage(msg, (scala.collection.immutable.Iterable<SelectionPathElement>)this.path(), false));
    }

    public void forward(Object message, ActorContext context) {
        this.tell(message, context.sender());
    }

    public Future<ActorRef> resolveOne(Timeout timeout) {
        ExecutionContext ec = ExecutionContexts$.MODULE$.parasitic();
        Promise p = Promise$.MODULE$.apply();
        ActorSelection qual$1 = package$.MODULE$.ask(this);
        Identify x$1 = new Identify(None$.MODULE$);
        Timeout x$2 = timeout;
        ActorRef x$3 = AskableActorSelection$.MODULE$.ask$default$3$extension(qual$1, x$1);
        AskableActorSelection$.MODULE$.ask$extension(qual$1, x$1, x$2, x$3).onComplete((Function1 & Serializable)x0$1 -> {
            Promise promise;
            ActorIdentity actorIdentity;
            Option<ActorRef> option;
            Success success;
            Object object;
            Try try_ = x0$1;
            if (try_ instanceof Success && (object = (success = (Success)try_).value()) instanceof ActorIdentity && (option = (actorIdentity = (ActorIdentity)object).ref()) instanceof Some) {
                Some some = (Some)option;
                ActorRef ref = (ActorRef)some.value();
                promise = p.success((Object)ref);
            } else {
                promise = p.failure((Throwable)new ActorNotFound(this));
            }
            return promise;
        }, ec);
        return p.future();
    }

    public Future<ActorRef> resolveOne(FiniteDuration timeout) {
        return this.resolveOne(Timeout$.MODULE$.durationToTimeout(timeout));
    }

    public CompletionStage<ActorRef> resolveOneCS(FiniteDuration timeout) {
        return FutureConverters$.MODULE$.toJava(this.resolveOne(timeout));
    }

    public CompletionStage<ActorRef> resolveOneCS(Duration timeout) {
        return this.resolveOne(timeout);
    }

    public CompletionStage<ActorRef> resolveOne(Duration timeout) {
        return FutureConverters$.MODULE$.toJava(this.resolveOne(JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(timeout))));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ActorSelection[Anchor(").append(this.anchor().path());
        Object object = this.anchor().path().uid() != 0 ? builder.append("#").append(this.anchor().path().uid()) : BoxedUnit.UNIT;
        builder.append("), Path(").append(this.path().mkString("/", "/", "")).append(")]");
        return builder.toString();
    }

    public ActorPath anchorPath() {
        return this.anchor().path();
    }

    public String pathString() {
        return this.path().mkString("/", "/", "");
    }

    public String toSerializationFormat() {
        String string;
        ActorRef actorRef2 = this.anchor();
        if (actorRef2 instanceof ActorRefWithCell) {
            ActorRefWithCell actorRefWithCell = (ActorRefWithCell)actorRef2;
            string = this.anchor().path().toStringWithAddress(actorRefWithCell.provider().getDefaultAddress());
        } else {
            string = this.anchor().path().toString();
        }
        String anchorPath = string;
        StringBuilder builder = new StringBuilder();
        builder.append(anchorPath);
        char lastChar = builder.charAt(builder.length() - 1);
        Object object = this.path().nonEmpty() && lastChar != '/' ? builder.append(this.path().mkString("/", "/", "")) : (this.path().nonEmpty() ? builder.append(this.path().mkString("/")) : BoxedUnit.UNIT);
        return builder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        Object object = obj;
        if (!(object instanceof ActorSelection)) return false;
        ActorSelection actorSelection = (ActorSelection)object;
        ActorRef actorRef2 = this.anchor();
        ActorRef actorRef3 = actorSelection.anchor();
        if (actorRef2 == null) {
            if (actorRef3 != null) {
                return false;
            }
        } else if (!((Object)actorRef2).equals(actorRef3)) return false;
        IndexedSeq<SelectionPathElement> indexedSeq = this.path();
        IndexedSeq<SelectionPathElement> indexedSeq2 = actorSelection.path();
        if (indexedSeq == null) {
            if (indexedSeq2 == null) return true;
            return false;
        } else {
            if (!indexedSeq.equals(indexedSeq2)) return false;
            return true;
        }
    }

    private int hashCode$lzycompute() {
        ActorSelection actorSelection = this;
        synchronized (actorSelection) {
            if (!this.bitmap$0) {
                int h = MurmurHash$.MODULE$.startHash(Statics.anyHash((Object)this.anchor()));
                h = MurmurHash$.MODULE$.extendHash(h, Statics.anyHash(this.path()), MurmurHash$.MODULE$.startMagicA(), MurmurHash$.MODULE$.startMagicB());
                this.hashCode = MurmurHash$.MODULE$.finalizeHash(h);
                this.bitmap$0 = true;
            }
        }
        return this.hashCode;
    }

    public int hashCode() {
        return !this.bitmap$0 ? this.hashCode$lzycompute() : this.hashCode;
    }
}

