/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.web;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletContextListener;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.aaa.web.FilterDetails;
import org.opendaylight.aaa.web.ResourceDetails;
import org.opendaylight.aaa.web.ServletDetails;
import org.opendaylight.aaa.web.ServletSpec;

public interface WebContext {
    public @NonNull String name();

    public @NonNull String contextPath();

    public boolean supportsSessions();

    public @NonNull List<ServletDetails> servlets();

    public @NonNull List<FilterDetails> filters();

    public @NonNull List<ServletContextListener> listeners();

    public @NonNull List<ResourceDetails> resources();

    public @NonNull Map<String, String> contextParams();

    public static @NonNull Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final ImmutableMap.Builder<String, String> contextParams = ImmutableMap.builder();
        private final ImmutableList.Builder<ServletDetails> servlets = ImmutableList.builder();
        private final ImmutableList.Builder<FilterDetails> filters = ImmutableList.builder();
        private final ImmutableList.Builder<ServletContextListener> listeners = ImmutableList.builder();
        private final ImmutableList.Builder<ResourceDetails> resources = ImmutableList.builder();
        private String name;
        private String contextPath;
        private boolean supportsSessions = true;

        private Builder() {
        }

        public @NonNull Builder name(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }

        public @NonNull Builder contextPath(String contextPath) {
            this.contextPath = ServletSpec.requireContextPath(contextPath);
            return this;
        }

        public @NonNull Builder addServlet(ServletDetails servlet) {
            this.servlets.add((Object)servlet);
            return this;
        }

        public @NonNull Builder addFilter(FilterDetails filter) {
            this.filters.add((Object)filter);
            return this;
        }

        public @NonNull Builder addListener(ServletContextListener listener) {
            this.listeners.add((Object)listener);
            return this;
        }

        public @NonNull Builder addResource(ResourceDetails resource) {
            this.resources.add((Object)resource);
            return this;
        }

        public @NonNull Builder putContextParam(String key, String value) {
            this.contextParams.put((Object)key, (Object)value);
            return this;
        }

        public Builder supportsSessions(boolean supportsSessions) {
            this.supportsSessions = supportsSessions;
            return this;
        }

        public @NonNull WebContext build() {
            if (this.contextPath == null) {
                throw new IllegalStateException("No contextPath specified");
            }
            return new ImmutableWebContext((String)(this.name != null ? this.name : this.contextPath + ".id"), this.contextPath, (ImmutableList<ServletDetails>)this.servlets.build(), (ImmutableList<FilterDetails>)this.filters.build(), (ImmutableList<ServletContextListener>)this.listeners.build(), (ImmutableList<ResourceDetails>)this.resources.build(), (ImmutableMap<String, String>)this.contextParams.build(), this.supportsSessions);
        }

        private static final class ImmutableWebContext
        extends Record
        implements WebContext {
            private final String name;
            private final String contextPath;
            private final ImmutableList<ServletDetails> servlets;
            private final ImmutableList<FilterDetails> filters;
            private final ImmutableList<ServletContextListener> listeners;
            private final ImmutableList<ResourceDetails> resources;
            private final ImmutableMap<String, String> contextParams;
            private final boolean supportsSessions;

            private ImmutableWebContext(String name, String contextPath, ImmutableList<ServletDetails> servlets, ImmutableList<FilterDetails> filters, ImmutableList<ServletContextListener> listeners, ImmutableList<ResourceDetails> resources, ImmutableMap<String, String> contextParams, boolean supportsSessions) {
                this.name = name;
                this.contextPath = contextPath;
                this.servlets = servlets;
                this.filters = filters;
                this.listeners = listeners;
                this.resources = resources;
                this.contextParams = contextParams;
                this.supportsSessions = supportsSessions;
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{ImmutableWebContext.class, "name;contextPath;servlets;filters;listeners;resources;contextParams;supportsSessions", "name", "contextPath", "servlets", "filters", "listeners", "resources", "contextParams", "supportsSessions"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ImmutableWebContext.class, "name;contextPath;servlets;filters;listeners;resources;contextParams;supportsSessions", "name", "contextPath", "servlets", "filters", "listeners", "resources", "contextParams", "supportsSessions"}, this);
            }

            @Override
            public final boolean equals(Object o) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ImmutableWebContext.class, "name;contextPath;servlets;filters;listeners;resources;contextParams;supportsSessions", "name", "contextPath", "servlets", "filters", "listeners", "resources", "contextParams", "supportsSessions"}, this, o);
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public String contextPath() {
                return this.contextPath;
            }

            public ImmutableList<ServletDetails> servlets() {
                return this.servlets;
            }

            public ImmutableList<FilterDetails> filters() {
                return this.filters;
            }

            public ImmutableList<ServletContextListener> listeners() {
                return this.listeners;
            }

            public ImmutableList<ResourceDetails> resources() {
                return this.resources;
            }

            public ImmutableMap<String, String> contextParams() {
                return this.contextParams;
            }

            @Override
            public boolean supportsSessions() {
                return this.supportsSessions;
            }
        }
    }
}

