/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.aaa.web;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.Filter;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.aaa.web.ServletSpec;

public interface FilterDetails {
    public @NonNull Filter filter();

    public @NonNull String name();

    public @NonNull List<String> urlPatterns();

    public @NonNull Map<String, String> initParams();

    public boolean asyncSupported();

    public static @NonNull Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private final ImmutableMap.Builder<String, String> initParams = ImmutableMap.builder();
        private final ImmutableList.Builder<String> urlPatterns = ImmutableList.builder();
        private Filter filter;
        private String name;
        private boolean asyncSupported;

        private Builder() {
        }

        public @NonNull Builder filter(Filter filter) {
            this.filter = Objects.requireNonNull(filter);
            return this;
        }

        public @NonNull Builder name(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }

        public @NonNull Builder addUrlPattern(String urlPattern) {
            this.urlPatterns.add((Object)ServletSpec.requireMappingSpec(urlPattern));
            return this;
        }

        public @NonNull Builder putInitParam(String key, String value) {
            this.initParams.put((Object)key, (Object)value);
            return this;
        }

        public @NonNull Builder asyncSupported(boolean asyncSupported) {
            this.asyncSupported = asyncSupported;
            return this;
        }

        public @NonNull FilterDetails build() {
            if (this.filter == null) {
                throw new IllegalStateException("No filter specified");
            }
            return new ImmutableFilterDetails(this.filter, this.name != null ? this.name : this.filter.getClass().getName(), (ImmutableList<String>)this.urlPatterns.build(), (ImmutableMap<String, String>)this.initParams.build(), this.asyncSupported);
        }

        private static final class ImmutableFilterDetails
        extends Record
        implements FilterDetails {
            private final Filter filter;
            private final String name;
            private final ImmutableList<String> urlPatterns;
            private final ImmutableMap<String, String> initParams;
            private final boolean asyncSupported;

            ImmutableFilterDetails(Filter filter, String name, ImmutableList<String> urlPatterns, ImmutableMap<String, String> initParams, boolean asyncSupported) {
                if (urlPatterns.isEmpty()) {
                    throw new IllegalStateException("No urlPattern specified");
                }
                this.filter = filter;
                this.name = name;
                this.urlPatterns = urlPatterns;
                this.initParams = initParams;
                this.asyncSupported = asyncSupported;
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{ImmutableFilterDetails.class, "filter;name;urlPatterns;initParams;asyncSupported", "filter", "name", "urlPatterns", "initParams", "asyncSupported"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ImmutableFilterDetails.class, "filter;name;urlPatterns;initParams;asyncSupported", "filter", "name", "urlPatterns", "initParams", "asyncSupported"}, this);
            }

            @Override
            public final boolean equals(Object o) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ImmutableFilterDetails.class, "filter;name;urlPatterns;initParams;asyncSupported", "filter", "name", "urlPatterns", "initParams", "asyncSupported"}, this, o);
            }

            @Override
            public Filter filter() {
                return this.filter;
            }

            @Override
            public String name() {
                return this.name;
            }

            public ImmutableList<String> urlPatterns() {
                return this.urlPatterns;
            }

            public ImmutableMap<String, String> initParams() {
                return this.initParams;
            }

            @Override
            public boolean asyncSupported() {
                return this.asyncSupported;
            }
        }
    }
}

