/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.Authentication;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.Domains;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.DomainsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.Grants;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.GrantsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.Roles;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.RolesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.Users;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.UsersBuilder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class AuthenticationBuilder {
    private Domains _domains;
    private Grants _grants;
    private Roles _roles;
    private Users _users;
    Map<Class<? extends Augmentation<Authentication>>, Augmentation<Authentication>> augmentation = Map.of();

    public AuthenticationBuilder() {
    }

    public AuthenticationBuilder(Authentication base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Authentication>>, Augmentation<Authentication>>(aug);
        }
        this._domains = base.getDomains();
        this._grants = base.getGrants();
        this._roles = base.getRoles();
        this._users = base.getUsers();
    }

    public static @NonNull Authentication empty() {
        return LazyEmpty.INSTANCE;
    }

    public Domains getDomains() {
        return this._domains;
    }

    public Grants getGrants() {
        return this._grants;
    }

    public Roles getRoles() {
        return this._roles;
    }

    public Users getUsers() {
        return this._users;
    }

    public <E$$ extends Augmentation<Authentication>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public AuthenticationBuilder setDomains(Domains value) {
        this._domains = value;
        return this;
    }

    public AuthenticationBuilder setGrants(Grants value) {
        this._grants = value;
        return this;
    }

    public AuthenticationBuilder setRoles(Roles value) {
        this._roles = value;
        return this;
    }

    public AuthenticationBuilder setUsers(Users value) {
        this._users = value;
        return this;
    }

    public AuthenticationBuilder addAugmentation(Augmentation<Authentication> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Authentication>>, Augmentation<Authentication>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public AuthenticationBuilder removeAugmentation(Class<? extends Augmentation<Authentication>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Authentication build() {
        return new AuthenticationImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull Authentication INSTANCE = new AuthenticationBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class AuthenticationImpl
    extends AbstractAugmentable<Authentication>
    implements Authentication {
        private final Domains _domains;
        private final Grants _grants;
        private final Roles _roles;
        private final Users _users;
        private int hash = 0;
        private volatile boolean hashValid = false;

        AuthenticationImpl(AuthenticationBuilder base) {
            super(base.augmentation);
            this._domains = base.getDomains();
            this._grants = base.getGrants();
            this._roles = base.getRoles();
            this._users = base.getUsers();
        }

        @Override
        public Domains getDomains() {
            return this._domains;
        }

        @Override
        public Grants getGrants() {
            return this._grants;
        }

        @Override
        public Roles getRoles() {
            return this._roles;
        }

        @Override
        public Users getUsers() {
            return this._users;
        }

        @Override
        public Domains nonnullDomains() {
            return Objects.requireNonNullElse(this.getDomains(), DomainsBuilder.empty());
        }

        @Override
        public Grants nonnullGrants() {
            return Objects.requireNonNullElse(this.getGrants(), GrantsBuilder.empty());
        }

        @Override
        public Roles nonnullRoles() {
            return Objects.requireNonNullElse(this.getRoles(), RolesBuilder.empty());
        }

        @Override
        public Users nonnullUsers() {
            return Objects.requireNonNullElse(this.getUsers(), UsersBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Authentication.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Authentication.bindingEquals(this, obj);
        }

        public String toString() {
            return Authentication.bindingToString(this);
        }
    }
}

