package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.http.permission;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link Permissions} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Permissions createPermissions(int fooXyzzy, int barBaz) {
 *         return new PermissionsBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Permissions, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Permissions
 *
 */
@Generated("mdsal-binding-generator")
public class PermissionsBuilder {

    private Set<Permissions.Actions> _actions;
    private String _role;


    Map<Class<? extends Augmentation<Permissions>>, Augmentation<Permissions>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public PermissionsBuilder() {
        // No-op
    }

    

    /**
     * Construct a builder initialized with state from specified {@link Permissions}.
     *
     * @param base Permissions from which the builder should be initialized
     */
    public PermissionsBuilder(Permissions base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._actions = base.getActions();
        this._role = base.getRole();
    }



    /**
     * Return current value associated with the property corresponding to {@link Permissions#getActions()}.
     *
     * @return current value
     */
    public Set<Permissions.Actions> getActions() {
        return _actions;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Permissions#getRole()}.
     *
     * @return current value
     */
    public String getRole() {
        return _role;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Permissions>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link Permissions#getActions()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public PermissionsBuilder setActions(final Set<Permissions.Actions> values) {
        this._actions = values;
        return this;
    }
    
    
    /**
     * Set the property corresponding to {@link Permissions#getRole()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public PermissionsBuilder setRole(final String value) {
        this._role = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public PermissionsBuilder addAugmentation(Augmentation<Permissions> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public PermissionsBuilder removeAugmentation(Class<? extends Augmentation<Permissions>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Permissions} instance.
     *
     * @return A new {@link Permissions} instance.
     */
    public @NonNull Permissions build() {
        return new PermissionsImpl(this);
    }

    private static final class PermissionsImpl
        extends AbstractAugmentable<Permissions>
        implements Permissions {
    
        private final Set<Permissions.Actions> _actions;
        private final String _role;
    
        PermissionsImpl(PermissionsBuilder base) {
            super(base.augmentation);
            this._actions = base.getActions();
            this._role = base.getRole();
        }
    
        @Override
        public Set<Permissions.Actions> getActions() {
            return _actions;
        }
        
        @Override
        public String getRole() {
            return _role;
        }
    
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Permissions.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Permissions.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Permissions.bindingToString(this);
        }
    }
}
