package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.http.permission;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.HttpPermission;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.EnumTypeObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>aaa</b>
 * <pre>
 * list permissions {
 *   leaf-list actions {
 *     type enumeration {
 *       enum get;
 *       enum put;
 *       enum post;
 *       enum patch;
 *       enum delete;
 *     }
 *   }
 *   leaf role {
 *     type string;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link PermissionsBuilder}.
 * @see PermissionsBuilder
 *
 *
 */
@Generated("mdsal-binding-generator")
public interface Permissions
    extends
    ChildOf<HttpPermission>,
    Augmentable<Permissions>
{


    /**
     *
     * <p>
     * This class represents the following YANG schema fragment defined in module <b>aaa</b>
     * <pre>
     * leaf-list actions {
     *   type enumeration {
     *     enum get;
     *     enum put;
     *     enum post;
     *     enum patch;
     *     enum delete;
     *   }
     * }
     * </pre>
     *
     */
    @Generated("mdsal-binding-generator")
    public enum Actions implements EnumTypeObject {
        Get(0, "get"),
        
        Put(1, "put"),
        
        Post(2, "post"),
        
        Patch(3, "patch"),
        
        Delete(4, "delete")
        ;
    
        private final @NonNull String name;
        private final int value;
    
        private Actions(int value, @NonNull String name) {
            this.value = value;
            this.name = name;
        }
    
        @Override
        public @NonNull String getName() {
            return name;
        }
    
        @Override
        public int getIntValue() {
            return value;
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified assigned name.
         *
         * @param name YANG assigned name
         * @return corresponding Actions item, or {@code null} if no such item exists
         * @throws NullPointerException if {@code name} is null
         */
        public static @Nullable Actions forName(String name) {
            return switch (name) {
                case "get" -> Get;
                case "put" -> Put;
                case "post" -> Post;
                case "patch" -> Patch;
                case "delete" -> Delete;
                default -> null;
            };
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding Actions item, or {@code null} if no such item exists
         */
        public static @Nullable Actions forValue(int intValue) {
            return switch (intValue) {
                case 0 -> Get;
                case 1 -> Put;
                case 2 -> Post;
                case 3 -> Patch;
                case 4 -> Delete;
                default -> null;
            };
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified assigned name.
         *
         * @param name YANG assigned name
         * @return corresponding Actions item
         * @throws NullPointerException if {@code name} is null
         * @throws IllegalArgumentException if {@code name} does not match any item
         */
        public static @NonNull Actions ofName(String name) {
            return CodeHelpers.checkEnum(forName(name), name);
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding Actions item
         * @throws IllegalArgumentException if {@code intValue} does not match any item
         */
        public static @NonNull Actions ofValue(int intValue) {
            return CodeHelpers.checkEnum(forValue(intValue), intValue);
        }
    }

    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("permissions");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.http.permission.Permissions> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.http.permission.Permissions.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.http.permission.@NonNull Permissions obj) {
        int result = 1;
        final int prime = 31;
        result = prime * result + Objects.hashCode(obj.getActions());
        result = prime * result + Objects.hashCode(obj.getRole());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.http.permission.@NonNull Permissions thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.http.permission.Permissions.class, obj);
        return other != null
            && Objects.equals(thisObj.getRole(), other.getRole())
            && Objects.equals(thisObj.getActions(), other.getActions())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.http.permission.@NonNull Permissions obj) {
        final var helper = MoreObjects.toStringHelper("Permissions");
        CodeHelpers.appendValue(helper, "actions", obj.getActions());
        CodeHelpers.appendValue(helper, "role", obj.getRole());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return actions, or {@code null} if it is not present.
     *
     * @return {@code Set<Actions>} actions, or {@code null} if it is not present.
     *
     */
    @Nullable Set<Actions> getActions();
    
    /**
     * Return actions, guaranteed to be non-null.
     *
     * @return {@code Set<Actions>} actions, guaranteed to be non-null.
     * @throws NoSuchElementException if actions is not present
     *
     */
    default @NonNull Set<Actions> requireActions() {
        return CodeHelpers.require(getActions(), "actions");
    }
    
    /**
     * Return role, or {@code null} if it is not present.
     *
     * @return {@code String} role, or {@code null} if it is not present.
     *
     */
    String getRole();
    
    /**
     * Return role, guaranteed to be non-null.
     *
     * @return {@code String} role, guaranteed to be non-null.
     * @throws NoSuchElementException if role is not present
     *
     */
    default @NonNull String requireRole() {
        return CodeHelpers.require(getRole(), "role");
    }

}

