package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.http.authorization.policies;
import com.google.common.base.MoreObjects;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Key;

/**
 * This class represents the key of {@link Policies} class.
 *
 * @see Policies
 *
 */
@Generated("mdsal-binding-generator")
public class PoliciesKey
 implements Key<Policies> {
    @java.io.Serial
    private static final long serialVersionUID = -6011797520204903867L;
    private final String _resource;


    /**
     * Constructs an instance.
     *
     * @param _resource the entity resource
     * @throws NullPointerException if any of the arguments are null
     */
    public PoliciesKey(@NonNull String _resource) {
        this._resource = CodeHelpers.requireKeyProp(_resource, "resource");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public PoliciesKey(PoliciesKey source) {
        this._resource = source._resource;
    }


    /**
     * Return resource, guaranteed to be non-null.
     *
     * @return {@code String} resource, guaranteed to be non-null.
     */
    public @NonNull String getResource() {
        return _resource;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_resource);
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof PoliciesKey other
            && Objects.equals(_resource, other._resource);
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(PoliciesKey.class);
        CodeHelpers.appendValue(helper, "resource", _resource);
        return helper.toString();
    }
}

