package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.roles;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.Role;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link Roles} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Roles createRoles(int fooXyzzy, int barBaz) {
 *         return new RolesBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Roles, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Roles
 *
 */
@Generated("mdsal-binding-generator")
public class RolesBuilder {

    private String _description;
    private String _domainid;
    private String _name;
    private String _roleid;
    private RolesKey key;


    Map<Class<? extends Augmentation<Roles>>, Augmentation<Roles>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public RolesBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link Role}.
     *
     * @param arg Role from which the builder should be initialized
     */
    public RolesBuilder(Role arg) {
        this._roleid = arg.getRoleid();
        this._name = arg.getName();
        this._description = arg.getDescription();
        this._domainid = arg.getDomainid();
    }
    
    

    /**
     * Construct a builder initialized with state from specified {@link Roles}.
     *
     * @param base Roles from which the builder should be initialized
     */
    public RolesBuilder(Roles base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._roleid = base.getRoleid();
        this._description = base.getDescription();
        this._domainid = base.getDomainid();
        this._name = base.getName();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link Role}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Role castArg) {
            this._roleid = castArg.getRoleid();
            this._name = castArg.getName();
            this._description = castArg.getDescription();
            this._domainid = castArg.getDomainid();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[Role]");
    }


    /**
     * Return current value associated with the property corresponding to {@link Roles#key()}.
     *
     * @return current value
     */
    public RolesKey key() {
        return key;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Roles#getDescription()}.
     *
     * @return current value
     */
    public String getDescription() {
        return _description;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Roles#getDomainid()}.
     *
     * @return current value
     */
    public String getDomainid() {
        return _domainid;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Roles#getName()}.
     *
     * @return current value
     */
    public String getName() {
        return _name;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Roles#getRoleid()}.
     *
     * @return current value
     */
    public String getRoleid() {
        return _roleid;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Roles>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    /**
     * Set the key value corresponding to {@link Roles#key()} to the specified
     * value.
     *
     * @param key desired value
     * @return this builder
     */
    public RolesBuilder withKey(final RolesKey key) {
        this.key = key;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Roles#getDescription()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public RolesBuilder setDescription(final String value) {
        this._description = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Roles#getDomainid()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public RolesBuilder setDomainid(final String value) {
        this._domainid = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Roles#getName()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public RolesBuilder setName(final String value) {
        this._name = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Roles#getRoleid()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public RolesBuilder setRoleid(final String value) {
        this._roleid = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public RolesBuilder addAugmentation(Augmentation<Roles> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public RolesBuilder removeAugmentation(Class<? extends Augmentation<Roles>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Roles} instance.
     *
     * @return A new {@link Roles} instance.
     */
    public @NonNull Roles build() {
        return new RolesImpl(this);
    }

    private static final class RolesImpl
        extends AbstractAugmentable<Roles>
        implements Roles {
    
        private final String _description;
        private final String _domainid;
        private final String _name;
        private final String _roleid;
        private final RolesKey key;
    
        RolesImpl(RolesBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new RolesKey(base.getRoleid());
            }
            this._roleid = key.getRoleid();
            this._description = base.getDescription();
            this._domainid = base.getDomainid();
            this._name = base.getName();
        }
    
        @Override
        public RolesKey key() {
            return key;
        }
        
        @Override
        public String getDescription() {
            return _description;
        }
        
        @Override
        public String getDomainid() {
            return _domainid;
        }
        
        @Override
        public String getName() {
            return _name;
        }
        
        @Override
        public String getRoleid() {
            return _roleid;
        }
    
        
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Roles.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Roles.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Roles.bindingToString(this);
        }
    }
}
