package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.grants;
import com.google.common.base.MoreObjects;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Key;

/**
 * This class represents the key of {@link Grants} class.
 *
 * @see Grants
 *
 */
@Generated("mdsal-binding-generator")
public class GrantsKey
 implements Key<Grants> {
    @java.io.Serial
    private static final long serialVersionUID = 7780233727235090655L;
    private final String _grantid;


    /**
     * Constructs an instance.
     *
     * @param _grantid the entity grantid
     * @throws NullPointerException if any of the arguments are null
     */
    public GrantsKey(@NonNull String _grantid) {
        this._grantid = CodeHelpers.requireKeyProp(_grantid, "grantid");
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public GrantsKey(GrantsKey source) {
        this._grantid = source._grantid;
    }


    /**
     * Return grantid, guaranteed to be non-null.
     *
     * @return {@code String} grantid, guaranteed to be non-null.
     */
    public @NonNull String getGrantid() {
        return _grantid;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_grantid);
    }

    @Override
    public final boolean equals(Object obj) {
        return this == obj || obj instanceof GrantsKey other
            && Objects.equals(_grantid, other._grantid);
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(GrantsKey.class);
        CodeHelpers.appendValue(helper, "grantid", _grantid);
        return helper.toString();
    }
}

