package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.authentication.grants;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.Grant;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link Grants} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Grants createGrants(int fooXyzzy, int barBaz) {
 *         return new GrantsBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Grants, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Grants
 *
 */
@Generated("mdsal-binding-generator")
public class GrantsBuilder {

    private String _domainid;
    private String _grantid;
    private String _roleid;
    private String _userid;
    private GrantsKey key;


    Map<Class<? extends Augmentation<Grants>>, Augmentation<Grants>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public GrantsBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link Grant}.
     *
     * @param arg Grant from which the builder should be initialized
     */
    public GrantsBuilder(Grant arg) {
        this._grantid = arg.getGrantid();
        this._domainid = arg.getDomainid();
        this._userid = arg.getUserid();
        this._roleid = arg.getRoleid();
    }
    
    

    /**
     * Construct a builder initialized with state from specified {@link Grants}.
     *
     * @param base Grants from which the builder should be initialized
     */
    public GrantsBuilder(Grants base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._grantid = base.getGrantid();
        this._domainid = base.getDomainid();
        this._roleid = base.getRoleid();
        this._userid = base.getUserid();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link Grant}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Grant castArg) {
            this._grantid = castArg.getGrantid();
            this._domainid = castArg.getDomainid();
            this._userid = castArg.getUserid();
            this._roleid = castArg.getRoleid();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[Grant]");
    }


    /**
     * Return current value associated with the property corresponding to {@link Grants#key()}.
     *
     * @return current value
     */
    public GrantsKey key() {
        return key;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Grants#getDomainid()}.
     *
     * @return current value
     */
    public String getDomainid() {
        return _domainid;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Grants#getGrantid()}.
     *
     * @return current value
     */
    public String getGrantid() {
        return _grantid;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Grants#getRoleid()}.
     *
     * @return current value
     */
    public String getRoleid() {
        return _roleid;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Grants#getUserid()}.
     *
     * @return current value
     */
    public String getUserid() {
        return _userid;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Grants>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    /**
     * Set the key value corresponding to {@link Grants#key()} to the specified
     * value.
     *
     * @param key desired value
     * @return this builder
     */
    public GrantsBuilder withKey(final GrantsKey key) {
        this.key = key;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Grants#getDomainid()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public GrantsBuilder setDomainid(final String value) {
        this._domainid = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Grants#getGrantid()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public GrantsBuilder setGrantid(final String value) {
        this._grantid = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Grants#getRoleid()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public GrantsBuilder setRoleid(final String value) {
        this._roleid = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Grants#getUserid()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public GrantsBuilder setUserid(final String value) {
        this._userid = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public GrantsBuilder addAugmentation(Augmentation<Grants> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public GrantsBuilder removeAugmentation(Class<? extends Augmentation<Grants>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Grants} instance.
     *
     * @return A new {@link Grants} instance.
     */
    public @NonNull Grants build() {
        return new GrantsImpl(this);
    }

    private static final class GrantsImpl
        extends AbstractAugmentable<Grants>
        implements Grants {
    
        private final String _domainid;
        private final String _grantid;
        private final String _roleid;
        private final String _userid;
        private final GrantsKey key;
    
        GrantsImpl(GrantsBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new GrantsKey(base.getGrantid());
            }
            this._grantid = key.getGrantid();
            this._domainid = base.getDomainid();
            this._roleid = base.getRoleid();
            this._userid = base.getUserid();
        }
    
        @Override
        public GrantsKey key() {
            return key;
        }
        
        @Override
        public String getDomainid() {
            return _domainid;
        }
        
        @Override
        public String getGrantid() {
            return _grantid;
        }
        
        @Override
        public String getRoleid() {
            return _roleid;
        }
        
        @Override
        public String getUserid() {
            return _userid;
        }
    
        
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Grants.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Grants.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Grants.bindingToString(this);
        }
    }
}
