package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>aaa</b>
 * <pre>
 * grouping user {
 *   leaf userid {
 *     type string;
 *   }
 *   leaf name {
 *     type string;
 *   }
 *   leaf description {
 *     type string;
 *     default "";
 *   }
 *   leaf enabled {
 *     type boolean;
 *     default true;
 *   }
 *   leaf email {
 *     type string;
 *     default "";
 *   }
 *   leaf password {
 *     type string;
 *   }
 *   leaf salt {
 *     type string;
 *   }
 *   leaf domainid {
 *     type string;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface User
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("user");

    @Override
    Class<? extends User> implementedInterface();
    
    /**
     * Return userid, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         An internal wiring detail in the form 'name@domain'.
     *     </code>
     * </pre>
     *
     * @return {@code String} userid, or {@code null} if it is not present.
     *
     */
    String getUserid();
    
    /**
     * Return userid, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         An internal wiring detail in the form 'name@domain'.
     *     </code>
     * </pre>
     *
     * @return {@code String} userid, guaranteed to be non-null.
     * @throws NoSuchElementException if userid is not present
     *
     */
    default @NonNull String requireUserid() {
        return CodeHelpers.require(getUserid(), "userid");
    }
    
    /**
     * Return name, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The name of the user.
     *     </code>
     * </pre>
     *
     * @return {@code String} name, or {@code null} if it is not present.
     *
     */
    String getName();
    
    /**
     * Return name, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The name of the user.
     *     </code>
     * </pre>
     *
     * @return {@code String} name, guaranteed to be non-null.
     * @throws NoSuchElementException if name is not present
     *
     */
    default @NonNull String requireName() {
        return CodeHelpers.require(getName(), "name");
    }
    
    /**
     * Return description, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         A description for the user; defaults to the empty string.
     *     </code>
     * </pre>
     *
     * @return {@code String} description, or {@code null} if it is not present.
     *
     */
    String getDescription();
    
    /**
     * Return description, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         A description for the user; defaults to the empty string.
     *     </code>
     * </pre>
     *
     * @return {@code String} description, guaranteed to be non-null.
     * @throws NoSuchElementException if description is not present
     *
     */
    default @NonNull String requireDescription() {
        return CodeHelpers.require(getDescription(), "description");
    }
    
    /**
     * Return enabled, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Whether or not the user is enabled; defaults to true.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} enabled, or {@code null} if it is not present.
     *
     */
    Boolean getEnabled();
    
    /**
     * Return enabled, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Whether or not the user is enabled; defaults to true.
     *     </code>
     * </pre>
     *
     * @return {@code Boolean} enabled, guaranteed to be non-null.
     * @throws NoSuchElementException if enabled is not present
     *
     */
    default @NonNull Boolean requireEnabled() {
        return CodeHelpers.require(getEnabled(), "enabled");
    }
    
    /**
     * Return email, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         An email address for the user; defaults to the empty string.
     *     </code>
     * </pre>
     *
     * @return {@code String} email, or {@code null} if it is not present.
     *
     */
    String getEmail();
    
    /**
     * Return email, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         An email address for the user; defaults to the empty string.
     *     </code>
     * </pre>
     *
     * @return {@code String} email, guaranteed to be non-null.
     * @throws NoSuchElementException if email is not present
     *
     */
    default @NonNull String requireEmail() {
        return CodeHelpers.require(getEmail(), "email");
    }
    
    /**
     * Return password, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         A one-way hashed and salted version of the users password.
     *     </code>
     * </pre>
     *
     * @return {@code String} password, or {@code null} if it is not present.
     *
     */
    String getPassword();
    
    /**
     * Return password, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         A one-way hashed and salted version of the users password.
     *     </code>
     * </pre>
     *
     * @return {@code String} password, guaranteed to be non-null.
     * @throws NoSuchElementException if password is not present
     *
     */
    default @NonNull String requirePassword() {
        return CodeHelpers.require(getPassword(), "password");
    }
    
    /**
     * Return salt, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         A user-specific salt used for password hashing.
     *     </code>
     * </pre>
     *
     * @return {@code String} salt, or {@code null} if it is not present.
     *
     */
    String getSalt();
    
    /**
     * Return salt, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         A user-specific salt used for password hashing.
     *     </code>
     * </pre>
     *
     * @return {@code String} salt, guaranteed to be non-null.
     * @throws NoSuchElementException if salt is not present
     *
     */
    default @NonNull String requireSalt() {
        return CodeHelpers.require(getSalt(), "salt");
    }
    
    /**
     * Return domainid, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The domain to which the user belongs.
     *     </code>
     * </pre>
     *
     * @return {@code String} domainid, or {@code null} if it is not present.
     *
     */
    String getDomainid();
    
    /**
     * Return domainid, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The domain to which the user belongs.
     *     </code>
     * </pre>
     *
     * @return {@code String} domainid, guaranteed to be non-null.
     * @throws NoSuchElementException if domainid is not present
     *
     */
    default @NonNull String requireDomainid() {
        return CodeHelpers.require(getDomainid(), "domainid");
    }

}

