package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.svc.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214.YangModuleInfoImpl;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>aaa</b>
 * <pre>
 * grouping grant {
 *   leaf grantid {
 *     type string;
 *   }
 *   leaf domainid {
 *     type string;
 *   }
 *   leaf userid {
 *     type string;
 *   }
 *   leaf roleid {
 *     type string;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface Grant
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = YangModuleInfoImpl.qnameOf("grant");

    @Override
    Class<? extends Grant> implementedInterface();
    
    /**
     * Return grantid, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         An internal wiring detail in the form 'userid@roleid@domainid'.
     *     </code>
     * </pre>
     *
     * @return {@code String} grantid, or {@code null} if it is not present.
     *
     */
    String getGrantid();
    
    /**
     * Return grantid, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         An internal wiring detail in the form 'userid@roleid@domainid'.
     *     </code>
     * </pre>
     *
     * @return {@code String} grantid, guaranteed to be non-null.
     * @throws NoSuchElementException if grantid is not present
     *
     */
    default @NonNull String requireGrantid() {
        return CodeHelpers.require(getGrantid(), "grantid");
    }
    
    /**
     * Return domainid, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         A reference to the domain.
     *     </code>
     * </pre>
     *
     * @return {@code String} domainid, or {@code null} if it is not present.
     *
     */
    String getDomainid();
    
    /**
     * Return domainid, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         A reference to the domain.
     *     </code>
     * </pre>
     *
     * @return {@code String} domainid, guaranteed to be non-null.
     * @throws NoSuchElementException if domainid is not present
     *
     */
    default @NonNull String requireDomainid() {
        return CodeHelpers.require(getDomainid(), "domainid");
    }
    
    /**
     * Return userid, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         A reference to the user.
     *     </code>
     * </pre>
     *
     * @return {@code String} userid, or {@code null} if it is not present.
     *
     */
    String getUserid();
    
    /**
     * Return userid, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         A reference to the user.
     *     </code>
     * </pre>
     *
     * @return {@code String} userid, guaranteed to be non-null.
     * @throws NoSuchElementException if userid is not present
     *
     */
    default @NonNull String requireUserid() {
        return CodeHelpers.require(getUserid(), "userid");
    }
    
    /**
     * Return roleid, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         A reference to the role.
     *     </code>
     * </pre>
     *
     * @return {@code String} roleid, or {@code null} if it is not present.
     *
     */
    String getRoleid();
    
    /**
     * Return roleid, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         A reference to the role.
     *     </code>
     * </pre>
     *
     * @return {@code String} roleid, guaranteed to be non-null.
     * @throws NoSuchElementException if roleid is not present
     *
     */
    default @NonNull String requireRoleid() {
        return CodeHelpers.require(getRoleid(), "roleid");
    }

}

