package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.aaa.rev161214;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>aaa</b>
 * <pre>
 * module aaa {
 *   yang-version 1;
 *   namespace urn:opendaylight:params:xml:ns:yang:aaa;
 *   prefix aaa;
 *   revision 2016-12-14 {
 *   }
 *   grouping user {
 *     leaf userid {
 *       type string;
 *     }
 *     leaf name {
 *       type string;
 *     }
 *     leaf description {
 *       type string;
 *       default "";
 *     }
 *     leaf enabled {
 *       type boolean;
 *       default true;
 *     }
 *     leaf email {
 *       type string;
 *       default "";
 *     }
 *     leaf password {
 *       type string;
 *     }
 *     leaf salt {
 *       type string;
 *     }
 *     leaf domainid {
 *       type string;
 *     }
 *   }
 *   grouping domain {
 *     leaf domainid {
 *       type string;
 *     }
 *     leaf name {
 *       type string;
 *     }
 *     leaf description {
 *       type string;
 *       default "";
 *     }
 *   }
 *   grouping role {
 *     leaf roleid {
 *       type string;
 *     }
 *     leaf name {
 *       type string;
 *     }
 *     leaf description {
 *       type string;
 *       default "";
 *     }
 *     leaf domainid {
 *       type string;
 *     }
 *   }
 *   grouping grant {
 *     leaf grantid {
 *       type string;
 *     }
 *     leaf domainid {
 *       type string;
 *     }
 *     leaf userid {
 *       type string;
 *     }
 *     leaf roleid {
 *       type string;
 *     }
 *   }
 *   container authentication {
 *     container domains {
 *       list domains {
 *         key domainid;
 *         uses domain;
 *       }
 *     }
 *     container users {
 *       list users {
 *         key userid;
 *         uses user;
 *       }
 *     }
 *     container roles {
 *       list roles {
 *         key roleid;
 *         uses role;
 *       }
 *     }
 *     container grants {
 *       list grants {
 *         key grantid;
 *         uses grant;
 *       }
 *     }
 *   }
 *   grouping http-permission {
 *     leaf resource {
 *       type string;
 *       default *;
 *     }
 *     leaf index {
 *       type uint32;
 *     }
 *     list permissions {
 *       leaf-list actions {
 *         type enumeration {
 *           enum get;
 *           enum put;
 *           enum post;
 *           enum patch;
 *           enum delete;
 *         }
 *       }
 *       leaf role {
 *         type string;
 *       }
 *     }
 *     leaf description {
 *       type string;
 *       default "";
 *     }
 *   }
 *   container http-authorization {
 *     container policies {
 *       list policies {
 *         key resource;
 *         unique index;
 *         uses http-permission;
 *         ordered-by user;
 *       }
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface AaaData
    extends
    DataRoot
{




    /**
     * Return authentication, or {@code null} if it is not present.
     *
     * @return {@code Authentication} authentication, or {@code null} if it is not present.
     *
     */
    Authentication getAuthentication();
    
    /**
     * Return authentication, or an empty instance if it is not present.
     *
     * @return {@code Authentication} authentication, or an empty instance if it is not present.
     *
     */
    @NonNull Authentication nonnullAuthentication();
    
    /**
     * Return httpAuthorization, or {@code null} if it is not present.
     *
     * @return {@code HttpAuthorization} httpAuthorization, or {@code null} if it is not present.
     *
     */
    HttpAuthorization getHttpAuthorization();
    
    /**
     * Return httpAuthorization, or an empty instance if it is not present.
     *
     * @return {@code HttpAuthorization} httpAuthorization, or an empty instance if it is not present.
     *
     */
    @NonNull HttpAuthorization nonnullHttpAuthorization();

}

