/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddrn.model;

import org.opendatadiscovery.oddrn.annotation.PathField;
import org.opendatadiscovery.oddrn.model.OddrnPath;

public class KinesisPathsModel
implements OddrnPath {
    @PathField
    private final String account;
    @PathField(dependency={"account"})
    private final String region;
    @PathField(prefix="streams", dependency={"region"})
    private final String stream;
    @PathField(prefix="shards", dependency={"stream"})
    private final String shard;
    @PathField(prefix="data_records", dependency={"shard"})
    private final String dataRecord;

    @Override
    public String prefix() {
        return "//kinesis";
    }

    @Override
    public String name() {
        return "kinesis";
    }

    KinesisPathsModel(String account, String region, String stream, String shard, String dataRecord) {
        this.account = account;
        this.region = region;
        this.stream = stream;
        this.shard = shard;
        this.dataRecord = dataRecord;
    }

    public static KinesisPathsModelBuilder builder() {
        return new KinesisPathsModelBuilder();
    }

    public KinesisPathsModelBuilder toBuilder() {
        return new KinesisPathsModelBuilder().account(this.account).region(this.region).stream(this.stream).shard(this.shard).dataRecord(this.dataRecord);
    }

    public String getAccount() {
        return this.account;
    }

    public String getRegion() {
        return this.region;
    }

    public String getStream() {
        return this.stream;
    }

    public String getShard() {
        return this.shard;
    }

    public String getDataRecord() {
        return this.dataRecord;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KinesisPathsModel)) {
            return false;
        }
        KinesisPathsModel other = (KinesisPathsModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        String this$stream = this.getStream();
        String other$stream = other.getStream();
        if (this$stream == null ? other$stream != null : !this$stream.equals(other$stream)) {
            return false;
        }
        String this$shard = this.getShard();
        String other$shard = other.getShard();
        if (this$shard == null ? other$shard != null : !this$shard.equals(other$shard)) {
            return false;
        }
        String this$dataRecord = this.getDataRecord();
        String other$dataRecord = other.getDataRecord();
        return !(this$dataRecord == null ? other$dataRecord != null : !this$dataRecord.equals(other$dataRecord));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KinesisPathsModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        String $stream = this.getStream();
        result = result * 59 + ($stream == null ? 43 : $stream.hashCode());
        String $shard = this.getShard();
        result = result * 59 + ($shard == null ? 43 : $shard.hashCode());
        String $dataRecord = this.getDataRecord();
        result = result * 59 + ($dataRecord == null ? 43 : $dataRecord.hashCode());
        return result;
    }

    public String toString() {
        return "KinesisPathsModel(account=" + this.getAccount() + ", region=" + this.getRegion() + ", stream=" + this.getStream() + ", shard=" + this.getShard() + ", dataRecord=" + this.getDataRecord() + ")";
    }

    public static class KinesisPathsModelBuilder {
        private String account;
        private String region;
        private String stream;
        private String shard;
        private String dataRecord;

        KinesisPathsModelBuilder() {
        }

        public KinesisPathsModelBuilder account(String account) {
            this.account = account;
            return this;
        }

        public KinesisPathsModelBuilder region(String region) {
            this.region = region;
            return this;
        }

        public KinesisPathsModelBuilder stream(String stream) {
            this.stream = stream;
            return this;
        }

        public KinesisPathsModelBuilder shard(String shard) {
            this.shard = shard;
            return this;
        }

        public KinesisPathsModelBuilder dataRecord(String dataRecord) {
            this.dataRecord = dataRecord;
            return this;
        }

        public KinesisPathsModel build() {
            return new KinesisPathsModel(this.account, this.region, this.stream, this.shard, this.dataRecord);
        }

        public String toString() {
            return "KinesisPathsModel.KinesisPathsModelBuilder(account=" + this.account + ", region=" + this.region + ", stream=" + this.stream + ", shard=" + this.shard + ", dataRecord=" + this.dataRecord + ")";
        }
    }
}

