/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddrn.model;

import org.opendatadiscovery.oddrn.annotation.PathField;
import org.opendatadiscovery.oddrn.model.OddrnPath;

public class HdfsPath
implements OddrnPath {
    @PathField
    private final String site;
    @PathField(prefix="paths", dependency={"site"})
    private final String path;

    @Override
    public String prefix() {
        return "//hdfs";
    }

    @Override
    public String name() {
        return "hdfs";
    }

    HdfsPath(String site, String path) {
        this.site = site;
        this.path = path;
    }

    public static HdfsPathBuilder builder() {
        return new HdfsPathBuilder();
    }

    public HdfsPathBuilder toBuilder() {
        return new HdfsPathBuilder().site(this.site).path(this.path);
    }

    public String getSite() {
        return this.site;
    }

    public String getPath() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HdfsPath)) {
            return false;
        }
        HdfsPath other = (HdfsPath)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$site = this.getSite();
        String other$site = other.getSite();
        if (this$site == null ? other$site != null : !this$site.equals(other$site)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        return !(this$path == null ? other$path != null : !this$path.equals(other$path));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HdfsPath;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $site = this.getSite();
        result = result * 59 + ($site == null ? 43 : $site.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        return result;
    }

    public String toString() {
        return "HdfsPath(site=" + this.getSite() + ", path=" + this.getPath() + ")";
    }

    public static class HdfsPathBuilder {
        private String site;
        private String path;

        HdfsPathBuilder() {
        }

        public HdfsPathBuilder site(String site) {
            this.site = site;
            return this;
        }

        public HdfsPathBuilder path(String path) {
            this.path = path;
            return this;
        }

        public HdfsPath build() {
            return new HdfsPath(this.site, this.path);
        }

        public String toString() {
            return "HdfsPath.HdfsPathBuilder(site=" + this.site + ", path=" + this.path + ")";
        }
    }
}

