/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddrn.model;

import org.opendatadiscovery.oddrn.annotation.PathField;
import org.opendatadiscovery.oddrn.model.OddrnPath;

public class GluePath
implements OddrnPath {
    @PathField
    private final String account;
    @PathField(dependency={"account"})
    private final String region;
    @PathField(prefix="databases", dependency={"region"})
    private final String database;
    @PathField(prefix="tables", dependency={"database"})
    private final String table;
    @PathField(prefix="columns", dependency={"table"})
    private final String column;
    @PathField(prefix="owners")
    private final String owner;
    @PathField(prefix="jobs")
    private final String job;
    @PathField(prefix="runs")
    private final String run;

    @Override
    public String prefix() {
        return "//glue";
    }

    @Override
    public String name() {
        return "glue";
    }

    GluePath(String account, String region, String database, String table, String column, String owner, String job, String run) {
        this.account = account;
        this.region = region;
        this.database = database;
        this.table = table;
        this.column = column;
        this.owner = owner;
        this.job = job;
        this.run = run;
    }

    public static GluePathBuilder builder() {
        return new GluePathBuilder();
    }

    public GluePathBuilder toBuilder() {
        return new GluePathBuilder().account(this.account).region(this.region).database(this.database).table(this.table).column(this.column).owner(this.owner).job(this.job).run(this.run);
    }

    public String getAccount() {
        return this.account;
    }

    public String getRegion() {
        return this.region;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getTable() {
        return this.table;
    }

    public String getColumn() {
        return this.column;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getJob() {
        return this.job;
    }

    public String getRun() {
        return this.run;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GluePath)) {
            return false;
        }
        GluePath other = (GluePath)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$table = this.getTable();
        String other$table = other.getTable();
        if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
            return false;
        }
        String this$column = this.getColumn();
        String other$column = other.getColumn();
        if (this$column == null ? other$column != null : !this$column.equals(other$column)) {
            return false;
        }
        String this$owner = this.getOwner();
        String other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        String this$job = this.getJob();
        String other$job = other.getJob();
        if (this$job == null ? other$job != null : !this$job.equals(other$job)) {
            return false;
        }
        String this$run = this.getRun();
        String other$run = other.getRun();
        return !(this$run == null ? other$run != null : !this$run.equals(other$run));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GluePath;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        String $column = this.getColumn();
        result = result * 59 + ($column == null ? 43 : $column.hashCode());
        String $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        String $job = this.getJob();
        result = result * 59 + ($job == null ? 43 : $job.hashCode());
        String $run = this.getRun();
        result = result * 59 + ($run == null ? 43 : $run.hashCode());
        return result;
    }

    public String toString() {
        return "GluePath(account=" + this.getAccount() + ", region=" + this.getRegion() + ", database=" + this.getDatabase() + ", table=" + this.getTable() + ", column=" + this.getColumn() + ", owner=" + this.getOwner() + ", job=" + this.getJob() + ", run=" + this.getRun() + ")";
    }

    public static class GluePathBuilder {
        private String account;
        private String region;
        private String database;
        private String table;
        private String column;
        private String owner;
        private String job;
        private String run;

        GluePathBuilder() {
        }

        public GluePathBuilder account(String account) {
            this.account = account;
            return this;
        }

        public GluePathBuilder region(String region) {
            this.region = region;
            return this;
        }

        public GluePathBuilder database(String database) {
            this.database = database;
            return this;
        }

        public GluePathBuilder table(String table) {
            this.table = table;
            return this;
        }

        public GluePathBuilder column(String column) {
            this.column = column;
            return this;
        }

        public GluePathBuilder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public GluePathBuilder job(String job) {
            this.job = job;
            return this;
        }

        public GluePathBuilder run(String run) {
            this.run = run;
            return this;
        }

        public GluePath build() {
            return new GluePath(this.account, this.region, this.database, this.table, this.column, this.owner, this.job, this.run);
        }

        public String toString() {
            return "GluePath.GluePathBuilder(account=" + this.account + ", region=" + this.region + ", database=" + this.database + ", table=" + this.table + ", column=" + this.column + ", owner=" + this.owner + ", job=" + this.job + ", run=" + this.run + ")";
        }
    }
}

