/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddrn.model;

import org.opendatadiscovery.oddrn.annotation.PathField;
import org.opendatadiscovery.oddrn.model.OddrnPath;

public class ElasticSearchPath
implements OddrnPath {
    @PathField
    private final String host;
    @PathField(prefix="indexes", dependency={"host"})
    private final String index;
    @PathField(prefix="fields", dependency={"index"})
    private final String field;

    @Override
    public String prefix() {
        return "//elasticsearch";
    }

    @Override
    public String name() {
        return "elasticsearch";
    }

    ElasticSearchPath(String host, String index, String field) {
        this.host = host;
        this.index = index;
        this.field = field;
    }

    public static ElasticSearchPathBuilder builder() {
        return new ElasticSearchPathBuilder();
    }

    public ElasticSearchPathBuilder toBuilder() {
        return new ElasticSearchPathBuilder().host(this.host).index(this.index).field(this.field);
    }

    public String getHost() {
        return this.host;
    }

    public String getIndex() {
        return this.index;
    }

    public String getField() {
        return this.field;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElasticSearchPath)) {
            return false;
        }
        ElasticSearchPath other = (ElasticSearchPath)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$index = this.getIndex();
        String other$index = other.getIndex();
        if (this$index == null ? other$index != null : !this$index.equals(other$index)) {
            return false;
        }
        String this$field = this.getField();
        String other$field = other.getField();
        return !(this$field == null ? other$field != null : !this$field.equals(other$field));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ElasticSearchPath;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : $index.hashCode());
        String $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        return result;
    }

    public String toString() {
        return "ElasticSearchPath(host=" + this.getHost() + ", index=" + this.getIndex() + ", field=" + this.getField() + ")";
    }

    public static class ElasticSearchPathBuilder {
        private String host;
        private String index;
        private String field;

        ElasticSearchPathBuilder() {
        }

        public ElasticSearchPathBuilder host(String host) {
            this.host = host;
            return this;
        }

        public ElasticSearchPathBuilder index(String index) {
            this.index = index;
            return this;
        }

        public ElasticSearchPathBuilder field(String field) {
            this.field = field;
            return this;
        }

        public ElasticSearchPath build() {
            return new ElasticSearchPath(this.host, this.index, this.field);
        }

        public String toString() {
            return "ElasticSearchPath.ElasticSearchPathBuilder(host=" + this.host + ", index=" + this.index + ", field=" + this.field + ")";
        }
    }
}

