/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddrn.model;

import org.opendatadiscovery.oddrn.annotation.PathField;
import org.opendatadiscovery.oddrn.model.OddrnPath;

public class DmsPathsModel
implements OddrnPath {
    @PathField
    private final String account;
    @PathField(dependency={"account"})
    private final String region;
    @PathField(prefix="tasks", dependency={"region"})
    private final String task;
    @PathField(prefix="runs", dependency={"task"})
    private final String run;

    @Override
    public String prefix() {
        return "//dms";
    }

    @Override
    public String name() {
        return "dms";
    }

    DmsPathsModel(String account, String region, String task, String run) {
        this.account = account;
        this.region = region;
        this.task = task;
        this.run = run;
    }

    public static DmsPathsModelBuilder builder() {
        return new DmsPathsModelBuilder();
    }

    public DmsPathsModelBuilder toBuilder() {
        return new DmsPathsModelBuilder().account(this.account).region(this.region).task(this.task).run(this.run);
    }

    public String getAccount() {
        return this.account;
    }

    public String getRegion() {
        return this.region;
    }

    public String getTask() {
        return this.task;
    }

    public String getRun() {
        return this.run;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DmsPathsModel)) {
            return false;
        }
        DmsPathsModel other = (DmsPathsModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        String this$task = this.getTask();
        String other$task = other.getTask();
        if (this$task == null ? other$task != null : !this$task.equals(other$task)) {
            return false;
        }
        String this$run = this.getRun();
        String other$run = other.getRun();
        return !(this$run == null ? other$run != null : !this$run.equals(other$run));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DmsPathsModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        String $task = this.getTask();
        result = result * 59 + ($task == null ? 43 : $task.hashCode());
        String $run = this.getRun();
        result = result * 59 + ($run == null ? 43 : $run.hashCode());
        return result;
    }

    public String toString() {
        return "DmsPathsModel(account=" + this.getAccount() + ", region=" + this.getRegion() + ", task=" + this.getTask() + ", run=" + this.getRun() + ")";
    }

    public static class DmsPathsModelBuilder {
        private String account;
        private String region;
        private String task;
        private String run;

        DmsPathsModelBuilder() {
        }

        public DmsPathsModelBuilder account(String account) {
            this.account = account;
            return this;
        }

        public DmsPathsModelBuilder region(String region) {
            this.region = region;
            return this;
        }

        public DmsPathsModelBuilder task(String task) {
            this.task = task;
            return this;
        }

        public DmsPathsModelBuilder run(String run) {
            this.run = run;
            return this;
        }

        public DmsPathsModel build() {
            return new DmsPathsModel(this.account, this.region, this.task, this.run);
        }

        public String toString() {
            return "DmsPathsModel.DmsPathsModelBuilder(account=" + this.account + ", region=" + this.region + ", task=" + this.task + ", run=" + this.run + ")";
        }
    }
}

