/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddrn.model;

import org.opendatadiscovery.oddrn.annotation.PathField;
import org.opendatadiscovery.oddrn.model.OddrnPath;

public class TableauPath
implements OddrnPath {
    @PathField
    private final String host;
    @PathField(prefix="workbooks", dependency={"host"})
    private final String workbook;
    @PathField(prefix="views", dependency={"workbook"})
    private final String view;
    @PathField(prefix="datasources", dependency={"workbook"})
    private final String datasource;
    @PathField(prefix="projects", dependency={"host"})
    private final String project;

    @Override
    public String prefix() {
        return "//tableau";
    }

    @Override
    public String name() {
        return "tableau";
    }

    TableauPath(String host, String workbook, String view, String datasource, String project) {
        this.host = host;
        this.workbook = workbook;
        this.view = view;
        this.datasource = datasource;
        this.project = project;
    }

    public static TableauPathBuilder builder() {
        return new TableauPathBuilder();
    }

    public TableauPathBuilder toBuilder() {
        return new TableauPathBuilder().host(this.host).workbook(this.workbook).view(this.view).datasource(this.datasource).project(this.project);
    }

    public String getHost() {
        return this.host;
    }

    public String getWorkbook() {
        return this.workbook;
    }

    public String getView() {
        return this.view;
    }

    public String getDatasource() {
        return this.datasource;
    }

    public String getProject() {
        return this.project;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableauPath)) {
            return false;
        }
        TableauPath other = (TableauPath)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$workbook = this.getWorkbook();
        String other$workbook = other.getWorkbook();
        if (this$workbook == null ? other$workbook != null : !this$workbook.equals(other$workbook)) {
            return false;
        }
        String this$view = this.getView();
        String other$view = other.getView();
        if (this$view == null ? other$view != null : !this$view.equals(other$view)) {
            return false;
        }
        String this$datasource = this.getDatasource();
        String other$datasource = other.getDatasource();
        if (this$datasource == null ? other$datasource != null : !this$datasource.equals(other$datasource)) {
            return false;
        }
        String this$project = this.getProject();
        String other$project = other.getProject();
        return !(this$project == null ? other$project != null : !this$project.equals(other$project));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TableauPath;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $workbook = this.getWorkbook();
        result = result * 59 + ($workbook == null ? 43 : $workbook.hashCode());
        String $view = this.getView();
        result = result * 59 + ($view == null ? 43 : $view.hashCode());
        String $datasource = this.getDatasource();
        result = result * 59 + ($datasource == null ? 43 : $datasource.hashCode());
        String $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        return result;
    }

    public String toString() {
        return "TableauPath(host=" + this.getHost() + ", workbook=" + this.getWorkbook() + ", view=" + this.getView() + ", datasource=" + this.getDatasource() + ", project=" + this.getProject() + ")";
    }

    public static class TableauPathBuilder {
        private String host;
        private String workbook;
        private String view;
        private String datasource;
        private String project;

        TableauPathBuilder() {
        }

        public TableauPathBuilder host(String host) {
            this.host = host;
            return this;
        }

        public TableauPathBuilder workbook(String workbook) {
            this.workbook = workbook;
            return this;
        }

        public TableauPathBuilder view(String view) {
            this.view = view;
            return this;
        }

        public TableauPathBuilder datasource(String datasource) {
            this.datasource = datasource;
            return this;
        }

        public TableauPathBuilder project(String project) {
            this.project = project;
            return this;
        }

        public TableauPath build() {
            return new TableauPath(this.host, this.workbook, this.view, this.datasource, this.project);
        }

        public String toString() {
            return "TableauPath.TableauPathBuilder(host=" + this.host + ", workbook=" + this.workbook + ", view=" + this.view + ", datasource=" + this.datasource + ", project=" + this.project + ")";
        }
    }
}

