/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddrn.model;

import org.opendatadiscovery.oddrn.annotation.PathField;
import org.opendatadiscovery.oddrn.model.OddrnPath;

public class PowerBiPathModel
implements OddrnPath {
    @PathField
    private final String account;
    @PathField(prefix="datasets", dependency={"account"})
    private final String dataset;
    @PathField(prefix="dashboards", dependency={"account"})
    private final String dashboard;

    @Override
    public String prefix() {
        return "//powerbi";
    }

    @Override
    public String name() {
        return "powerbi";
    }

    PowerBiPathModel(String account, String dataset, String dashboard) {
        this.account = account;
        this.dataset = dataset;
        this.dashboard = dashboard;
    }

    public static PowerBiPathModelBuilder builder() {
        return new PowerBiPathModelBuilder();
    }

    public PowerBiPathModelBuilder toBuilder() {
        return new PowerBiPathModelBuilder().account(this.account).dataset(this.dataset).dashboard(this.dashboard);
    }

    public String getAccount() {
        return this.account;
    }

    public String getDataset() {
        return this.dataset;
    }

    public String getDashboard() {
        return this.dashboard;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PowerBiPathModel)) {
            return false;
        }
        PowerBiPathModel other = (PowerBiPathModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        String this$dataset = this.getDataset();
        String other$dataset = other.getDataset();
        if (this$dataset == null ? other$dataset != null : !this$dataset.equals(other$dataset)) {
            return false;
        }
        String this$dashboard = this.getDashboard();
        String other$dashboard = other.getDashboard();
        return !(this$dashboard == null ? other$dashboard != null : !this$dashboard.equals(other$dashboard));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PowerBiPathModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        String $dataset = this.getDataset();
        result = result * 59 + ($dataset == null ? 43 : $dataset.hashCode());
        String $dashboard = this.getDashboard();
        result = result * 59 + ($dashboard == null ? 43 : $dashboard.hashCode());
        return result;
    }

    public String toString() {
        return "PowerBiPathModel(account=" + this.getAccount() + ", dataset=" + this.getDataset() + ", dashboard=" + this.getDashboard() + ")";
    }

    public static class PowerBiPathModelBuilder {
        private String account;
        private String dataset;
        private String dashboard;

        PowerBiPathModelBuilder() {
        }

        public PowerBiPathModelBuilder account(String account) {
            this.account = account;
            return this;
        }

        public PowerBiPathModelBuilder dataset(String dataset) {
            this.dataset = dataset;
            return this;
        }

        public PowerBiPathModelBuilder dashboard(String dashboard) {
            this.dashboard = dashboard;
            return this;
        }

        public PowerBiPathModel build() {
            return new PowerBiPathModel(this.account, this.dataset, this.dashboard);
        }

        public String toString() {
            return "PowerBiPathModel.PowerBiPathModelBuilder(account=" + this.account + ", dataset=" + this.dataset + ", dashboard=" + this.dashboard + ")";
        }
    }
}

