/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddrn.model;

import org.opendatadiscovery.oddrn.annotation.PathField;
import org.opendatadiscovery.oddrn.model.OddrnPath;
import org.opendatadiscovery.oddrn.model.RdsPath;

public class MysqlPath
implements OddrnPath,
RdsPath {
    @PathField
    private final String host;
    @PathField(prefix="databases", dependency={"host"})
    private final String database;
    @PathField(prefix="tables", dependency={"database"})
    private final String table;
    @PathField(prefix="views", dependency={"database"})
    private final String view;
    @PathField(prefix="columns", dependency={"table", "view"})
    private final String column;

    @Override
    public String prefix() {
        return "//mysql";
    }

    @Override
    public String name() {
        return "mysql";
    }

    MysqlPath(String host, String database, String table, String view, String column) {
        this.host = host;
        this.database = database;
        this.table = table;
        this.view = view;
        this.column = column;
    }

    public static MysqlPathBuilder builder() {
        return new MysqlPathBuilder();
    }

    public MysqlPathBuilder toBuilder() {
        return new MysqlPathBuilder().host(this.host).database(this.database).table(this.table).view(this.view).column(this.column);
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public String getView() {
        return this.view;
    }

    @Override
    public String getColumn() {
        return this.column;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MysqlPath)) {
            return false;
        }
        MysqlPath other = (MysqlPath)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$table = this.getTable();
        String other$table = other.getTable();
        if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
            return false;
        }
        String this$view = this.getView();
        String other$view = other.getView();
        if (this$view == null ? other$view != null : !this$view.equals(other$view)) {
            return false;
        }
        String this$column = this.getColumn();
        String other$column = other.getColumn();
        return !(this$column == null ? other$column != null : !this$column.equals(other$column));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MysqlPath;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        String $view = this.getView();
        result = result * 59 + ($view == null ? 43 : $view.hashCode());
        String $column = this.getColumn();
        result = result * 59 + ($column == null ? 43 : $column.hashCode());
        return result;
    }

    public String toString() {
        return "MysqlPath(host=" + this.getHost() + ", database=" + this.getDatabase() + ", table=" + this.getTable() + ", view=" + this.getView() + ", column=" + this.getColumn() + ")";
    }

    public static class MysqlPathBuilder {
        private String host;
        private String database;
        private String table;
        private String view;
        private String column;

        MysqlPathBuilder() {
        }

        public MysqlPathBuilder host(String host) {
            this.host = host;
            return this;
        }

        public MysqlPathBuilder database(String database) {
            this.database = database;
            return this;
        }

        public MysqlPathBuilder table(String table) {
            this.table = table;
            return this;
        }

        public MysqlPathBuilder view(String view) {
            this.view = view;
            return this;
        }

        public MysqlPathBuilder column(String column) {
            this.column = column;
            return this;
        }

        public MysqlPath build() {
            return new MysqlPath(this.host, this.database, this.table, this.view, this.column);
        }

        public String toString() {
            return "MysqlPath.MysqlPathBuilder(host=" + this.host + ", database=" + this.database + ", table=" + this.table + ", view=" + this.view + ", column=" + this.column + ")";
        }
    }
}

