/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddrn.model;

import org.opendatadiscovery.oddrn.annotation.PathField;
import org.opendatadiscovery.oddrn.model.OddrnPath;

public class MetabasePathModel
implements OddrnPath {
    @PathField
    private final String host;
    @PathField(prefix="collections", dependency={"host"})
    private final String collection;
    @PathField(prefix="dashboards", dependency={"collection"})
    private final String dashboard;
    @PathField(prefix="cards", dependency={"collection"})
    private final String card;

    @Override
    public String prefix() {
        return "//metabase";
    }

    @Override
    public String name() {
        return "metabase";
    }

    MetabasePathModel(String host, String collection, String dashboard, String card) {
        this.host = host;
        this.collection = collection;
        this.dashboard = dashboard;
        this.card = card;
    }

    public static MetabasePathModelBuilder builder() {
        return new MetabasePathModelBuilder();
    }

    public MetabasePathModelBuilder toBuilder() {
        return new MetabasePathModelBuilder().host(this.host).collection(this.collection).dashboard(this.dashboard).card(this.card);
    }

    public String getHost() {
        return this.host;
    }

    public String getCollection() {
        return this.collection;
    }

    public String getDashboard() {
        return this.dashboard;
    }

    public String getCard() {
        return this.card;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetabasePathModel)) {
            return false;
        }
        MetabasePathModel other = (MetabasePathModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$collection = this.getCollection();
        String other$collection = other.getCollection();
        if (this$collection == null ? other$collection != null : !this$collection.equals(other$collection)) {
            return false;
        }
        String this$dashboard = this.getDashboard();
        String other$dashboard = other.getDashboard();
        if (this$dashboard == null ? other$dashboard != null : !this$dashboard.equals(other$dashboard)) {
            return false;
        }
        String this$card = this.getCard();
        String other$card = other.getCard();
        return !(this$card == null ? other$card != null : !this$card.equals(other$card));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MetabasePathModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $collection = this.getCollection();
        result = result * 59 + ($collection == null ? 43 : $collection.hashCode());
        String $dashboard = this.getDashboard();
        result = result * 59 + ($dashboard == null ? 43 : $dashboard.hashCode());
        String $card = this.getCard();
        result = result * 59 + ($card == null ? 43 : $card.hashCode());
        return result;
    }

    public String toString() {
        return "MetabasePathModel(host=" + this.getHost() + ", collection=" + this.getCollection() + ", dashboard=" + this.getDashboard() + ", card=" + this.getCard() + ")";
    }

    public static class MetabasePathModelBuilder {
        private String host;
        private String collection;
        private String dashboard;
        private String card;

        MetabasePathModelBuilder() {
        }

        public MetabasePathModelBuilder host(String host) {
            this.host = host;
            return this;
        }

        public MetabasePathModelBuilder collection(String collection) {
            this.collection = collection;
            return this;
        }

        public MetabasePathModelBuilder dashboard(String dashboard) {
            this.dashboard = dashboard;
            return this;
        }

        public MetabasePathModelBuilder card(String card) {
            this.card = card;
            return this;
        }

        public MetabasePathModel build() {
            return new MetabasePathModel(this.host, this.collection, this.dashboard, this.card);
        }

        public String toString() {
            return "MetabasePathModel.MetabasePathModelBuilder(host=" + this.host + ", collection=" + this.collection + ", dashboard=" + this.dashboard + ", card=" + this.card + ")";
        }
    }
}

