/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddrn.model;

import org.opendatadiscovery.oddrn.annotation.PathField;
import org.opendatadiscovery.oddrn.model.OddrnPath;

public class LambdaPathsModel
implements OddrnPath {
    @PathField
    private final String account;
    @PathField(dependency={"account"})
    private final String region;
    @PathField(prefix="functions", dependency={"region"})
    private final String function;

    @Override
    public String prefix() {
        return "//lambda";
    }

    @Override
    public String name() {
        return "lambda";
    }

    LambdaPathsModel(String account, String region, String function) {
        this.account = account;
        this.region = region;
        this.function = function;
    }

    public static LambdaPathsModelBuilder builder() {
        return new LambdaPathsModelBuilder();
    }

    public LambdaPathsModelBuilder toBuilder() {
        return new LambdaPathsModelBuilder().account(this.account).region(this.region).function(this.function);
    }

    public String getAccount() {
        return this.account;
    }

    public String getRegion() {
        return this.region;
    }

    public String getFunction() {
        return this.function;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LambdaPathsModel)) {
            return false;
        }
        LambdaPathsModel other = (LambdaPathsModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        String this$function = this.getFunction();
        String other$function = other.getFunction();
        return !(this$function == null ? other$function != null : !this$function.equals(other$function));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LambdaPathsModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        String $function = this.getFunction();
        result = result * 59 + ($function == null ? 43 : $function.hashCode());
        return result;
    }

    public String toString() {
        return "LambdaPathsModel(account=" + this.getAccount() + ", region=" + this.getRegion() + ", function=" + this.getFunction() + ")";
    }

    public static class LambdaPathsModelBuilder {
        private String account;
        private String region;
        private String function;

        LambdaPathsModelBuilder() {
        }

        public LambdaPathsModelBuilder account(String account) {
            this.account = account;
            return this;
        }

        public LambdaPathsModelBuilder region(String region) {
            this.region = region;
            return this;
        }

        public LambdaPathsModelBuilder function(String function) {
            this.function = function;
            return this;
        }

        public LambdaPathsModel build() {
            return new LambdaPathsModel(this.account, this.region, this.function);
        }

        public String toString() {
            return "LambdaPathsModel.LambdaPathsModelBuilder(account=" + this.account + ", region=" + this.region + ", function=" + this.function + ")";
        }
    }
}

