/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddrn.model;

import org.opendatadiscovery.oddrn.annotation.PathField;
import org.opendatadiscovery.oddrn.model.OddrnPath;

public class HttpServicePath
implements OddrnPath {
    @PathField
    private final String host;
    @PathField(prefix="methods", dependency={"host"})
    private final String method;
    @PathField(prefix="paths", dependency={"method"})
    private final String path;

    @Override
    public String prefix() {
        return "//http";
    }

    @Override
    public String name() {
        return "http_service";
    }

    HttpServicePath(String host, String method, String path) {
        this.host = host;
        this.method = method;
        this.path = path;
    }

    public static HttpServicePathBuilder builder() {
        return new HttpServicePathBuilder();
    }

    public HttpServicePathBuilder toBuilder() {
        return new HttpServicePathBuilder().host(this.host).method(this.method).path(this.path);
    }

    public String getHost() {
        return this.host;
    }

    public String getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpServicePath)) {
            return false;
        }
        HttpServicePath other = (HttpServicePath)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        return !(this$path == null ? other$path != null : !this$path.equals(other$path));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpServicePath;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        return result;
    }

    public String toString() {
        return "HttpServicePath(host=" + this.getHost() + ", method=" + this.getMethod() + ", path=" + this.getPath() + ")";
    }

    public static class HttpServicePathBuilder {
        private String host;
        private String method;
        private String path;

        HttpServicePathBuilder() {
        }

        public HttpServicePathBuilder host(String host) {
            this.host = host;
            return this;
        }

        public HttpServicePathBuilder method(String method) {
            this.method = method;
            return this;
        }

        public HttpServicePathBuilder path(String path) {
            this.path = path;
            return this;
        }

        public HttpServicePath build() {
            return new HttpServicePath(this.host, this.method, this.path);
        }

        public String toString() {
            return "HttpServicePath.HttpServicePathBuilder(host=" + this.host + ", method=" + this.method + ", path=" + this.path + ")";
        }
    }
}

