/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddrn.model;

import org.opendatadiscovery.oddrn.annotation.PathField;
import org.opendatadiscovery.oddrn.model.OddrnPath;

public class FivetranPathsModel
implements OddrnPath {
    @PathField
    private final String host;
    @PathField(prefix="transformers", dependency={"host"})
    private final String transformer;

    @Override
    public String prefix() {
        return "//fivetran";
    }

    @Override
    public String name() {
        return "fivetran";
    }

    FivetranPathsModel(String host, String transformer) {
        this.host = host;
        this.transformer = transformer;
    }

    public static FivetranPathsModelBuilder builder() {
        return new FivetranPathsModelBuilder();
    }

    public FivetranPathsModelBuilder toBuilder() {
        return new FivetranPathsModelBuilder().host(this.host).transformer(this.transformer);
    }

    public String getHost() {
        return this.host;
    }

    public String getTransformer() {
        return this.transformer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FivetranPathsModel)) {
            return false;
        }
        FivetranPathsModel other = (FivetranPathsModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$transformer = this.getTransformer();
        String other$transformer = other.getTransformer();
        return !(this$transformer == null ? other$transformer != null : !this$transformer.equals(other$transformer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FivetranPathsModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $transformer = this.getTransformer();
        result = result * 59 + ($transformer == null ? 43 : $transformer.hashCode());
        return result;
    }

    public String toString() {
        return "FivetranPathsModel(host=" + this.getHost() + ", transformer=" + this.getTransformer() + ")";
    }

    public static class FivetranPathsModelBuilder {
        private String host;
        private String transformer;

        FivetranPathsModelBuilder() {
        }

        public FivetranPathsModelBuilder host(String host) {
            this.host = host;
            return this;
        }

        public FivetranPathsModelBuilder transformer(String transformer) {
            this.transformer = transformer;
            return this;
        }

        public FivetranPathsModel build() {
            return new FivetranPathsModel(this.host, this.transformer);
        }

        public String toString() {
            return "FivetranPathsModel.FivetranPathsModelBuilder(host=" + this.host + ", transformer=" + this.transformer + ")";
        }
    }
}

