/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddrn.model;

import org.opendatadiscovery.oddrn.annotation.PathField;
import org.opendatadiscovery.oddrn.model.OddrnPath;

public class FeastPath
implements OddrnPath {
    @PathField
    private final String host;
    @PathField(prefix="featureviews", dependency={"host"})
    private final String featureview;
    @PathField(prefix="features", dependency={"featureview"})
    private final String feature;
    @PathField(prefix="subfeatures", dependency={"feature"})
    private final String subfeature;

    @Override
    public String prefix() {
        return "//feast";
    }

    @Override
    public String name() {
        return "feast";
    }

    FeastPath(String host, String featureview, String feature, String subfeature) {
        this.host = host;
        this.featureview = featureview;
        this.feature = feature;
        this.subfeature = subfeature;
    }

    public static FeastPathBuilder builder() {
        return new FeastPathBuilder();
    }

    public FeastPathBuilder toBuilder() {
        return new FeastPathBuilder().host(this.host).featureview(this.featureview).feature(this.feature).subfeature(this.subfeature);
    }

    public String getHost() {
        return this.host;
    }

    public String getFeatureview() {
        return this.featureview;
    }

    public String getFeature() {
        return this.feature;
    }

    public String getSubfeature() {
        return this.subfeature;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeastPath)) {
            return false;
        }
        FeastPath other = (FeastPath)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$featureview = this.getFeatureview();
        String other$featureview = other.getFeatureview();
        if (this$featureview == null ? other$featureview != null : !this$featureview.equals(other$featureview)) {
            return false;
        }
        String this$feature = this.getFeature();
        String other$feature = other.getFeature();
        if (this$feature == null ? other$feature != null : !this$feature.equals(other$feature)) {
            return false;
        }
        String this$subfeature = this.getSubfeature();
        String other$subfeature = other.getSubfeature();
        return !(this$subfeature == null ? other$subfeature != null : !this$subfeature.equals(other$subfeature));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FeastPath;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $featureview = this.getFeatureview();
        result = result * 59 + ($featureview == null ? 43 : $featureview.hashCode());
        String $feature = this.getFeature();
        result = result * 59 + ($feature == null ? 43 : $feature.hashCode());
        String $subfeature = this.getSubfeature();
        result = result * 59 + ($subfeature == null ? 43 : $subfeature.hashCode());
        return result;
    }

    public String toString() {
        return "FeastPath(host=" + this.getHost() + ", featureview=" + this.getFeatureview() + ", feature=" + this.getFeature() + ", subfeature=" + this.getSubfeature() + ")";
    }

    public static class FeastPathBuilder {
        private String host;
        private String featureview;
        private String feature;
        private String subfeature;

        FeastPathBuilder() {
        }

        public FeastPathBuilder host(String host) {
            this.host = host;
            return this;
        }

        public FeastPathBuilder featureview(String featureview) {
            this.featureview = featureview;
            return this;
        }

        public FeastPathBuilder feature(String feature) {
            this.feature = feature;
            return this;
        }

        public FeastPathBuilder subfeature(String subfeature) {
            this.subfeature = subfeature;
            return this;
        }

        public FeastPath build() {
            return new FeastPath(this.host, this.featureview, this.feature, this.subfeature);
        }

        public String toString() {
            return "FeastPath.FeastPathBuilder(host=" + this.host + ", featureview=" + this.featureview + ", feature=" + this.feature + ", subfeature=" + this.subfeature + ")";
        }
    }
}

