/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddrn.model;

import org.opendatadiscovery.oddrn.annotation.PathField;
import org.opendatadiscovery.oddrn.model.OddrnPath;

public class AthenaPath
implements OddrnPath {
    @PathField
    private final String account;
    @PathField(dependency={"account"})
    private final String region;
    @PathField(prefix="catalogs", dependency={"region"})
    private final String catalog;
    @PathField(prefix="databases", dependency={"catalog"})
    private final String database;
    @PathField(prefix="tables", dependency={"database"})
    private final String table;
    @PathField(prefix="views", dependency={"database"})
    private final String view;
    @PathField(prefix="columns", dependency={"table", "view"})
    private final String column;

    @Override
    public String prefix() {
        return "//athena";
    }

    @Override
    public String name() {
        return "athena";
    }

    AthenaPath(String account, String region, String catalog, String database, String table, String view, String column) {
        this.account = account;
        this.region = region;
        this.catalog = catalog;
        this.database = database;
        this.table = table;
        this.view = view;
        this.column = column;
    }

    public static AthenaPathBuilder builder() {
        return new AthenaPathBuilder();
    }

    public AthenaPathBuilder toBuilder() {
        return new AthenaPathBuilder().account(this.account).region(this.region).catalog(this.catalog).database(this.database).table(this.table).view(this.view).column(this.column);
    }

    public String getAccount() {
        return this.account;
    }

    public String getRegion() {
        return this.region;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getTable() {
        return this.table;
    }

    public String getView() {
        return this.view;
    }

    public String getColumn() {
        return this.column;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AthenaPath)) {
            return false;
        }
        AthenaPath other = (AthenaPath)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        String this$region = this.getRegion();
        String other$region = other.getRegion();
        if (this$region == null ? other$region != null : !this$region.equals(other$region)) {
            return false;
        }
        String this$catalog = this.getCatalog();
        String other$catalog = other.getCatalog();
        if (this$catalog == null ? other$catalog != null : !this$catalog.equals(other$catalog)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$table = this.getTable();
        String other$table = other.getTable();
        if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
            return false;
        }
        String this$view = this.getView();
        String other$view = other.getView();
        if (this$view == null ? other$view != null : !this$view.equals(other$view)) {
            return false;
        }
        String this$column = this.getColumn();
        String other$column = other.getColumn();
        return !(this$column == null ? other$column != null : !this$column.equals(other$column));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AthenaPath;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        String $region = this.getRegion();
        result = result * 59 + ($region == null ? 43 : $region.hashCode());
        String $catalog = this.getCatalog();
        result = result * 59 + ($catalog == null ? 43 : $catalog.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        String $view = this.getView();
        result = result * 59 + ($view == null ? 43 : $view.hashCode());
        String $column = this.getColumn();
        result = result * 59 + ($column == null ? 43 : $column.hashCode());
        return result;
    }

    public String toString() {
        return "AthenaPath(account=" + this.getAccount() + ", region=" + this.getRegion() + ", catalog=" + this.getCatalog() + ", database=" + this.getDatabase() + ", table=" + this.getTable() + ", view=" + this.getView() + ", column=" + this.getColumn() + ")";
    }

    public static class AthenaPathBuilder {
        private String account;
        private String region;
        private String catalog;
        private String database;
        private String table;
        private String view;
        private String column;

        AthenaPathBuilder() {
        }

        public AthenaPathBuilder account(String account) {
            this.account = account;
            return this;
        }

        public AthenaPathBuilder region(String region) {
            this.region = region;
            return this;
        }

        public AthenaPathBuilder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public AthenaPathBuilder database(String database) {
            this.database = database;
            return this;
        }

        public AthenaPathBuilder table(String table) {
            this.table = table;
            return this;
        }

        public AthenaPathBuilder view(String view) {
            this.view = view;
            return this;
        }

        public AthenaPathBuilder column(String column) {
            this.column = column;
            return this;
        }

        public AthenaPath build() {
            return new AthenaPath(this.account, this.region, this.catalog, this.database, this.table, this.view, this.column);
        }

        public String toString() {
            return "AthenaPath.AthenaPathBuilder(account=" + this.account + ", region=" + this.region + ", catalog=" + this.catalog + ", database=" + this.database + ", table=" + this.table + ", view=" + this.view + ", column=" + this.column + ")";
        }
    }
}

