/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddrn;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opendatadiscovery.oddrn.annotation.PathField;
import org.opendatadiscovery.oddrn.exception.EmptyPathValueException;
import org.opendatadiscovery.oddrn.exception.GenerateException;
import org.opendatadiscovery.oddrn.exception.PathDoesntExistException;
import org.opendatadiscovery.oddrn.model.AirflowPath;
import org.opendatadiscovery.oddrn.model.AwsS3Path;
import org.opendatadiscovery.oddrn.model.CustomS3Path;
import org.opendatadiscovery.oddrn.model.DynamodbPath;
import org.opendatadiscovery.oddrn.model.GrpcServicePath;
import org.opendatadiscovery.oddrn.model.HdfsPath;
import org.opendatadiscovery.oddrn.model.HivePath;
import org.opendatadiscovery.oddrn.model.KafkaConnectorPath;
import org.opendatadiscovery.oddrn.model.KafkaPath;
import org.opendatadiscovery.oddrn.model.MysqlPath;
import org.opendatadiscovery.oddrn.model.ODDPlatformDataEntityGroupPath;
import org.opendatadiscovery.oddrn.model.ODDPlatformDataSourcePath;
import org.opendatadiscovery.oddrn.model.OddrnPath;
import org.opendatadiscovery.oddrn.model.PostgreSqlPath;
import org.opendatadiscovery.oddrn.model.SnowflakePath;
import org.opendatadiscovery.oddrn.model.SparkPath;
import org.opendatadiscovery.oddrn.util.GeneratorUtil;

public class Generator {
    static final String GET_PREFIX = "get";
    private static final Map<Class<?>, Function<String, ?>> RETURN_TYPE_MAPPING = new HashMap();
    private final Map<Class<? extends OddrnPath>, ModelDescription> cache = Stream.of(AirflowPath.class, DynamodbPath.class, GrpcServicePath.class, HivePath.class, KafkaConnectorPath.class, KafkaPath.class, MysqlPath.class, PostgreSqlPath.class, SnowflakePath.class, SparkPath.class, AwsS3Path.class, CustomS3Path.class, HdfsPath.class, ODDPlatformDataSourcePath.class, ODDPlatformDataEntityGroupPath.class).collect(Collectors.toMap(c -> c, this::generateModel));

    public static Generator getInstance() {
        return LazyHolder.INSTANCE;
    }

    public static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        return name.substring(0, 1).toUpperCase(Locale.ENGLISH) + name.substring(1);
    }

    public void register(Class<? extends OddrnPath> clazz) {
        this.generateModel(clazz);
    }

    public Optional<OddrnPath> parse(String oddrn) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Optional<OddrnPath> result = Optional.empty();
        for (ModelDescription description : this.cache.values()) {
            if (!oddrn.startsWith(description.prefix + "/")) continue;
            String withoutPrefix = oddrn.substring(description.prefix.length());
            Object builder = description.builderMethod.invoke(null, new Object[0]);
            int nextFieldPos = 0;
            do {
                int fieldNamePos = withoutPrefix.indexOf("/", nextFieldPos);
                int valuePos = withoutPrefix.indexOf("/", fieldNamePos + 1);
                nextFieldPos = withoutPrefix.indexOf("/", valuePos + 1);
                if (fieldNamePos < 0 || valuePos < 0) continue;
                String fieldName = withoutPrefix.substring(fieldNamePos + 1, valuePos);
                String stringValue = nextFieldPos > 0 ? withoutPrefix.substring(valuePos + 1, nextFieldPos) : withoutPrefix.substring(valuePos + 1);
                ModelField modelField = (ModelField)description.prefixes.get(fieldName);
                if (modelField == null) continue;
                Class<?> returnType = modelField.getReadMethod().getReturnType();
                Function<String, ?> mapper = RETURN_TYPE_MAPPING.get(returnType);
                if (mapper == null) {
                    throw new IllegalArgumentException(String.format("Field path of type %s is not supported", returnType));
                }
                modelField.setMethod.invoke(builder, mapper.apply(GeneratorUtil.unescape(stringValue)));
            } while (nextFieldPos >= 0);
            return Optional.ofNullable((OddrnPath)builder.getClass().getMethod("build", new Class[0]).invoke(builder, new Object[0]));
        }
        return result;
    }

    public String generate(OddrnPath path) throws GenerateException {
        try {
            Object result;
            ModelDescription modelDescription = this.cache.computeIfAbsent(path.getClass(), this::generateModel);
            Iterator iterator = modelDescription.fields.iterator();
            ModelField field = null;
            while (iterator.hasNext() && (result = (field = (ModelField)iterator.next()).readMethod.invoke((Object)path, new Object[0])) == null) {
            }
            if (field != null) {
                return this.generate(path, modelDescription, field);
            }
            throw new GenerateException("All fields are empty");
        }
        catch (Exception e) {
            if (e instanceof GenerateException) {
                throw (GenerateException)e;
            }
            throw new GenerateException("Generate error", e);
        }
    }

    public String generate(OddrnPath path, ModelDescription description, ModelField field) throws GenerateException {
        try {
            this.validatePath(path, description, field);
            Map fields = description.fieldsMap;
            ArrayList<ModelField> pathFields = new ArrayList<ModelField>();
            ModelField currentField = field;
            pathFields.add(currentField);
            block2: while (currentField.pathField.dependency().length > 0 && !currentField.pathField.dependency()[0].isEmpty()) {
                for (String dependency : currentField.pathField.dependency()) {
                    if (dependency.isEmpty()) continue;
                    Optional<ModelField> find = Optional.ofNullable((ModelField)fields.get(dependency));
                    if (find.isPresent()) {
                        currentField = find.get();
                        pathFields.add(currentField);
                        continue block2;
                    }
                    throw new PathDoesntExistException(String.format("Path %s doesn't exist in generator", String.join((CharSequence)" ,", currentField.pathField.dependency())));
                }
            }
            Collections.reverse(pathFields);
            StringBuilder builder = new StringBuilder();
            builder.append(path.prefix());
            for (ModelField modelField : pathFields) {
                String prefix = modelField.pathField.prefix().isEmpty() ? modelField.getField().getName() : modelField.pathField.prefix();
                builder.append("/");
                builder.append(prefix);
                builder.append("/");
                builder.append(GeneratorUtil.escape(modelField.readMethod.invoke((Object)path, new Object[0]).toString()));
            }
            return builder.toString();
        }
        catch (Exception e) {
            if (e instanceof GenerateException) {
                throw (GenerateException)e;
            }
            throw new GenerateException("Generate error", e);
        }
    }

    public void validateAllPaths(OddrnPath model) throws GenerateException {
        ModelDescription modelDescription = this.cache.computeIfAbsent(model.getClass(), this::generateModel);
        for (ModelField field : modelDescription.fields) {
            this.validatePath(model, modelDescription, field);
        }
    }

    public void validatePath(OddrnPath path, ModelDescription description, ModelField field) throws GenerateException {
        try {
            String fieldName = field.name;
            boolean allFailed = true;
            Exception lastException = null;
            if (field.pathField.dependency().length > 0) {
                for (String dependency : field.pathField.dependency()) {
                    if (dependency.isEmpty()) continue;
                    ModelField modelField = description.fields.stream().filter(f -> ((ModelField)f).name.equals(dependency)).findFirst().orElseThrow(() -> new PathDoesntExistException(dependency));
                    try {
                        this.validatePath(path, description, modelField);
                        allFailed = false;
                    }
                    catch (Exception e) {
                        lastException = e;
                    }
                }
            }
            if (allFailed && lastException != null) {
                throw lastException;
            }
            if (!field.pathField.nullable() && (field.getReadMethod().invoke((Object)path, new Object[0]) == null || field.getReadMethod().invoke((Object)path, new Object[0]).toString().trim().isEmpty())) {
                throw new EmptyPathValueException(String.format("'Attribute %s' is empty", fieldName));
            }
        }
        catch (Exception e) {
            if (e instanceof GenerateException) {
                throw (GenerateException)e;
            }
            throw new GenerateException("Generate error", e);
        }
    }

    private ModelDescription generateModel(Class<? extends OddrnPath> clazz) {
        ModelDescription.ModelDescriptionBuilder descriptionBuilder = ModelDescription.builder();
        HashMap<String, ModelField> fieldsMap = new HashMap<String, ModelField>();
        HashMap<String, ModelField> prefixes = new HashMap<String, ModelField>();
        Class<? extends OddrnPath> currentClazz = clazz;
        Class<?> builderClazz = clazz.getMethod("builder", new Class[0]).getReturnType();
        Method builderMethod = clazz.getMethod("builder", new Class[0]);
        Object builder = builderMethod.invoke(null, new Object[0]);
        Object build = builder.getClass().getMethod("build", new Class[0]).invoke(builder, new Object[0]);
        String prefix = build.getClass().getMethod("prefix", new Class[0]).invoke(build, new Object[0]).toString();
        descriptionBuilder.prefix(prefix);
        descriptionBuilder.builderMethod(clazz.getMethod("builder", new Class[0]));
        while (OddrnPath.class.isAssignableFrom(currentClazz)) {
            for (Field field : currentClazz.getDeclaredFields()) {
                PathField[] pathFields = (PathField[])field.getAnnotationsByType(PathField.class);
                if (pathFields.length <= 0) continue;
                Method getMethod = clazz.getMethod(GET_PREFIX + Generator.capitalize(field.getName()), new Class[0]);
                Method setMethod = builderClazz.getMethod(field.getName(), getMethod.getReturnType());
                ModelField model = ModelField.builder().name(field.getName()).field(field).pathField(pathFields[0]).readMethod(getMethod).setMethod(setMethod).build();
                PathField pathField = pathFields[0];
                String fieldPrefix = pathField.prefix().isEmpty() ? field.getName() : pathField.prefix();
                fieldsMap.put(field.getName(), model);
                prefixes.put(fieldPrefix, model);
            }
            currentClazz = currentClazz.getSuperclass();
        }
        LinkedList<ModelField> fields = new LinkedList<ModelField>();
        LinkedList<String> fieldNames = new LinkedList<String>();
        HashSet<String> processedFields = new HashSet<String>();
        LinkedList fieldsToProcess = new LinkedList(fieldsMap.keySet());
        while (!fieldsToProcess.isEmpty()) {
            String fieldName = (String)fieldsToProcess.pop();
            if (processedFields.contains(fieldName)) continue;
            ModelField modelField = (ModelField)fieldsMap.get(fieldName);
            String[] dependency = modelField.pathField.dependency();
            ArrayList<String> dependencies = new ArrayList<String>();
            if (dependency != null && dependency.length > 0) {
                boolean restart = false;
                for (String dependencyName : dependency) {
                    if (dependencyName.isEmpty()) continue;
                    dependencies.add(dependencyName);
                    if (processedFields.contains(dependencyName)) continue;
                    fieldsToProcess.push(fieldName);
                    fieldsToProcess.push(dependencyName);
                    restart = true;
                }
                if (restart) continue;
            }
            int pos = dependencies.stream().mapToInt(fieldNames::indexOf).max().orElse(0);
            fields.add(pos, (ModelField)fieldsMap.get(fieldName));
            fieldNames.add(pos, fieldName);
            processedFields.add(fieldName);
        }
        descriptionBuilder.prefixes(prefixes);
        descriptionBuilder.fields(fields);
        descriptionBuilder.fieldsMap(fieldsMap);
        return descriptionBuilder.build();
    }

    static {
        RETURN_TYPE_MAPPING.put(String.class, Function.identity());
        RETURN_TYPE_MAPPING.put(Integer.class, Integer::parseInt);
        RETURN_TYPE_MAPPING.put(Long.class, Long::parseLong);
        RETURN_TYPE_MAPPING.put(Double.class, Double::parseDouble);
        RETURN_TYPE_MAPPING.put(Float.class, Float::parseFloat);
    }

    private static class ModelField {
        private final String name;
        private final Field field;
        private final Method readMethod;
        private final Method setMethod;
        private final PathField pathField;

        ModelField(String name, Field field, Method readMethod, Method setMethod, PathField pathField) {
            this.name = name;
            this.field = field;
            this.readMethod = readMethod;
            this.setMethod = setMethod;
            this.pathField = pathField;
        }

        public static ModelFieldBuilder builder() {
            return new ModelFieldBuilder();
        }

        public String getName() {
            return this.name;
        }

        public Field getField() {
            return this.field;
        }

        public Method getReadMethod() {
            return this.readMethod;
        }

        public Method getSetMethod() {
            return this.setMethod;
        }

        public PathField getPathField() {
            return this.pathField;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ModelField)) {
                return false;
            }
            ModelField other = (ModelField)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Field this$field = this.getField();
            Field other$field = other.getField();
            if (this$field == null ? other$field != null : !((Object)this$field).equals(other$field)) {
                return false;
            }
            Method this$readMethod = this.getReadMethod();
            Method other$readMethod = other.getReadMethod();
            if (this$readMethod == null ? other$readMethod != null : !((Object)this$readMethod).equals(other$readMethod)) {
                return false;
            }
            Method this$setMethod = this.getSetMethod();
            Method other$setMethod = other.getSetMethod();
            if (this$setMethod == null ? other$setMethod != null : !((Object)this$setMethod).equals(other$setMethod)) {
                return false;
            }
            PathField this$pathField = this.getPathField();
            PathField other$pathField = other.getPathField();
            return !(this$pathField == null ? other$pathField != null : !this$pathField.equals(other$pathField));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ModelField;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Field $field = this.getField();
            result = result * 59 + ($field == null ? 43 : ((Object)$field).hashCode());
            Method $readMethod = this.getReadMethod();
            result = result * 59 + ($readMethod == null ? 43 : ((Object)$readMethod).hashCode());
            Method $setMethod = this.getSetMethod();
            result = result * 59 + ($setMethod == null ? 43 : ((Object)$setMethod).hashCode());
            PathField $pathField = this.getPathField();
            result = result * 59 + ($pathField == null ? 43 : $pathField.hashCode());
            return result;
        }

        public String toString() {
            return "Generator.ModelField(name=" + this.getName() + ", field=" + this.getField() + ", readMethod=" + this.getReadMethod() + ", setMethod=" + this.getSetMethod() + ", pathField=" + this.getPathField() + ")";
        }

        public static class ModelFieldBuilder {
            private String name;
            private Field field;
            private Method readMethod;
            private Method setMethod;
            private PathField pathField;

            ModelFieldBuilder() {
            }

            public ModelFieldBuilder name(String name) {
                this.name = name;
                return this;
            }

            public ModelFieldBuilder field(Field field) {
                this.field = field;
                return this;
            }

            public ModelFieldBuilder readMethod(Method readMethod) {
                this.readMethod = readMethod;
                return this;
            }

            public ModelFieldBuilder setMethod(Method setMethod) {
                this.setMethod = setMethod;
                return this;
            }

            public ModelFieldBuilder pathField(PathField pathField) {
                this.pathField = pathField;
                return this;
            }

            public ModelField build() {
                return new ModelField(this.name, this.field, this.readMethod, this.setMethod, this.pathField);
            }

            public String toString() {
                return "Generator.ModelField.ModelFieldBuilder(name=" + this.name + ", field=" + this.field + ", readMethod=" + this.readMethod + ", setMethod=" + this.setMethod + ", pathField=" + this.pathField + ")";
            }
        }
    }

    private static class ModelDescription {
        private final Map<String, ModelField> prefixes;
        private final Map<String, ModelField> fieldsMap;
        private final List<ModelField> fields;
        private final String prefix;
        private final Method builderMethod;

        ModelDescription(Map<String, ModelField> prefixes, Map<String, ModelField> fieldsMap, List<ModelField> fields, String prefix, Method builderMethod) {
            this.prefixes = prefixes;
            this.fieldsMap = fieldsMap;
            this.fields = fields;
            this.prefix = prefix;
            this.builderMethod = builderMethod;
        }

        public static ModelDescriptionBuilder builder() {
            return new ModelDescriptionBuilder();
        }

        public Map<String, ModelField> getPrefixes() {
            return this.prefixes;
        }

        public Map<String, ModelField> getFieldsMap() {
            return this.fieldsMap;
        }

        public List<ModelField> getFields() {
            return this.fields;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public Method getBuilderMethod() {
            return this.builderMethod;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ModelDescription)) {
                return false;
            }
            ModelDescription other = (ModelDescription)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, ModelField> this$prefixes = this.getPrefixes();
            Map<String, ModelField> other$prefixes = other.getPrefixes();
            if (this$prefixes == null ? other$prefixes != null : !((Object)this$prefixes).equals(other$prefixes)) {
                return false;
            }
            Map<String, ModelField> this$fieldsMap = this.getFieldsMap();
            Map<String, ModelField> other$fieldsMap = other.getFieldsMap();
            if (this$fieldsMap == null ? other$fieldsMap != null : !((Object)this$fieldsMap).equals(other$fieldsMap)) {
                return false;
            }
            List<ModelField> this$fields = this.getFields();
            List<ModelField> other$fields = other.getFields();
            if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
                return false;
            }
            String this$prefix = this.getPrefix();
            String other$prefix = other.getPrefix();
            if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
                return false;
            }
            Method this$builderMethod = this.getBuilderMethod();
            Method other$builderMethod = other.getBuilderMethod();
            return !(this$builderMethod == null ? other$builderMethod != null : !((Object)this$builderMethod).equals(other$builderMethod));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ModelDescription;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, ModelField> $prefixes = this.getPrefixes();
            result = result * 59 + ($prefixes == null ? 43 : ((Object)$prefixes).hashCode());
            Map<String, ModelField> $fieldsMap = this.getFieldsMap();
            result = result * 59 + ($fieldsMap == null ? 43 : ((Object)$fieldsMap).hashCode());
            List<ModelField> $fields = this.getFields();
            result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
            String $prefix = this.getPrefix();
            result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
            Method $builderMethod = this.getBuilderMethod();
            result = result * 59 + ($builderMethod == null ? 43 : ((Object)$builderMethod).hashCode());
            return result;
        }

        public String toString() {
            return "Generator.ModelDescription(prefixes=" + this.getPrefixes() + ", fieldsMap=" + this.getFieldsMap() + ", fields=" + this.getFields() + ", prefix=" + this.getPrefix() + ", builderMethod=" + this.getBuilderMethod() + ")";
        }

        public static class ModelDescriptionBuilder {
            private Map<String, ModelField> prefixes;
            private Map<String, ModelField> fieldsMap;
            private List<ModelField> fields;
            private String prefix;
            private Method builderMethod;

            ModelDescriptionBuilder() {
            }

            public ModelDescriptionBuilder prefixes(Map<String, ModelField> prefixes) {
                this.prefixes = prefixes;
                return this;
            }

            public ModelDescriptionBuilder fieldsMap(Map<String, ModelField> fieldsMap) {
                this.fieldsMap = fieldsMap;
                return this;
            }

            public ModelDescriptionBuilder fields(List<ModelField> fields) {
                this.fields = fields;
                return this;
            }

            public ModelDescriptionBuilder prefix(String prefix) {
                this.prefix = prefix;
                return this;
            }

            public ModelDescriptionBuilder builderMethod(Method builderMethod) {
                this.builderMethod = builderMethod;
                return this;
            }

            public ModelDescription build() {
                return new ModelDescription(this.prefixes, this.fieldsMap, this.fields, this.prefix, this.builderMethod);
            }

            public String toString() {
                return "Generator.ModelDescription.ModelDescriptionBuilder(prefixes=" + this.prefixes + ", fieldsMap=" + this.fieldsMap + ", fields=" + this.fields + ", prefix=" + this.prefix + ", builderMethod=" + this.builderMethod + ")";
            }
        }
    }

    private static class LazyHolder {
        static final Generator INSTANCE = new Generator();

        private LazyHolder() {
        }
    }
}

