/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddrn.processor;

import org.opendatadiscovery.oddrn.model.OddrnPath;
import org.opendatadiscovery.oddrn.model.SnowflakePath;
import org.opendatadiscovery.oddrn.processor.JdbcProcessor;

public class SnowflakeJdbcProcessor
implements JdbcProcessor<SnowflakePath> {
    public static final String PREFIX = "snowflake";

    @Override
    public OddrnPath path(String host, String database) {
        return SnowflakePath.builder().account(host.substring(0, host.indexOf("."))).build();
    }

    @Override
    public String url(SnowflakePath path, int port) {
        return String.format("jdbc:%s://%s.snowflakecomputing.com", PREFIX, path.getAccount());
    }
}

