/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddrn.model;

import org.opendatadiscovery.oddrn.annotation.PathField;
import org.opendatadiscovery.oddrn.model.OddrnPath;

public class SparkPath
implements OddrnPath {
    @PathField
    private final String host;
    @PathField(dependency={"host"}, prefix="jobs")
    private final String job;
    @PathField(dependency={"job"}, prefix="runs")
    private final String run;

    @Override
    public String prefix() {
        return "//spark";
    }

    SparkPath(String host, String job, String run) {
        this.host = host;
        this.job = job;
        this.run = run;
    }

    public static SparkPathBuilder builder() {
        return new SparkPathBuilder();
    }

    public String getHost() {
        return this.host;
    }

    public String getJob() {
        return this.job;
    }

    public String getRun() {
        return this.run;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SparkPath)) {
            return false;
        }
        SparkPath other = (SparkPath)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$job = this.getJob();
        String other$job = other.getJob();
        if (this$job == null ? other$job != null : !this$job.equals(other$job)) {
            return false;
        }
        String this$run = this.getRun();
        String other$run = other.getRun();
        return !(this$run == null ? other$run != null : !this$run.equals(other$run));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SparkPath;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $job = this.getJob();
        result = result * 59 + ($job == null ? 43 : $job.hashCode());
        String $run = this.getRun();
        result = result * 59 + ($run == null ? 43 : $run.hashCode());
        return result;
    }

    public String toString() {
        return "SparkPath(host=" + this.getHost() + ", job=" + this.getJob() + ", run=" + this.getRun() + ")";
    }

    public static class SparkPathBuilder {
        private String host;
        private String job;
        private String run;

        SparkPathBuilder() {
        }

        public SparkPathBuilder host(String host) {
            this.host = host;
            return this;
        }

        public SparkPathBuilder job(String job) {
            this.job = job;
            return this;
        }

        public SparkPathBuilder run(String run) {
            this.run = run;
            return this;
        }

        public SparkPath build() {
            return new SparkPath(this.host, this.job, this.run);
        }

        public String toString() {
            return "SparkPath.SparkPathBuilder(host=" + this.host + ", job=" + this.job + ", run=" + this.run + ")";
        }
    }
}

