/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddrn.model;

import org.opendatadiscovery.oddrn.annotation.PathField;
import org.opendatadiscovery.oddrn.model.OddrnPath;
import org.opendatadiscovery.oddrn.model.RdsPath;

public class PostgreSqlPath
implements OddrnPath,
RdsPath {
    @PathField
    private final String host;
    @PathField(dependency={"host"}, prefix="databases")
    private final String database;
    @PathField(dependency={"database"}, prefix="schemas")
    private final String schema;
    @PathField(dependency={"schema"}, prefix="tables")
    private final String table;
    @PathField(dependency={"schema"}, prefix="views")
    private final String view;
    @PathField(dependency={"table", "view"}, prefix="columns")
    private final String column;

    @Override
    public String prefix() {
        return "//postgresql";
    }

    PostgreSqlPath(String host, String database, String schema, String table, String view, String column) {
        this.host = host;
        this.database = database;
        this.schema = schema;
        this.table = table;
        this.view = view;
        this.column = column;
    }

    public static PostgreSqlPathBuilder builder() {
        return new PostgreSqlPathBuilder();
    }

    public PostgreSqlPathBuilder toBuilder() {
        return new PostgreSqlPathBuilder().host(this.host).database(this.database).schema(this.schema).table(this.table).view(this.view).column(this.column);
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    public String getSchema() {
        return this.schema;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public String getView() {
        return this.view;
    }

    @Override
    public String getColumn() {
        return this.column;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PostgreSqlPath)) {
            return false;
        }
        PostgreSqlPath other = (PostgreSqlPath)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        if (this$database == null ? other$database != null : !this$database.equals(other$database)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        String this$table = this.getTable();
        String other$table = other.getTable();
        if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
            return false;
        }
        String this$view = this.getView();
        String other$view = other.getView();
        if (this$view == null ? other$view != null : !this$view.equals(other$view)) {
            return false;
        }
        String this$column = this.getColumn();
        String other$column = other.getColumn();
        return !(this$column == null ? other$column != null : !this$column.equals(other$column));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PostgreSqlPath;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        String $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        String $view = this.getView();
        result = result * 59 + ($view == null ? 43 : $view.hashCode());
        String $column = this.getColumn();
        result = result * 59 + ($column == null ? 43 : $column.hashCode());
        return result;
    }

    public String toString() {
        return "PostgreSqlPath(host=" + this.getHost() + ", database=" + this.getDatabase() + ", schema=" + this.getSchema() + ", table=" + this.getTable() + ", view=" + this.getView() + ", column=" + this.getColumn() + ")";
    }

    public static class PostgreSqlPathBuilder {
        private String host;
        private String database;
        private String schema;
        private String table;
        private String view;
        private String column;

        PostgreSqlPathBuilder() {
        }

        public PostgreSqlPathBuilder host(String host) {
            this.host = host;
            return this;
        }

        public PostgreSqlPathBuilder database(String database) {
            this.database = database;
            return this;
        }

        public PostgreSqlPathBuilder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public PostgreSqlPathBuilder table(String table) {
            this.table = table;
            return this;
        }

        public PostgreSqlPathBuilder view(String view) {
            this.view = view;
            return this;
        }

        public PostgreSqlPathBuilder column(String column) {
            this.column = column;
            return this;
        }

        public PostgreSqlPath build() {
            return new PostgreSqlPath(this.host, this.database, this.schema, this.table, this.view, this.column);
        }

        public String toString() {
            return "PostgreSqlPath.PostgreSqlPathBuilder(host=" + this.host + ", database=" + this.database + ", schema=" + this.schema + ", table=" + this.table + ", view=" + this.view + ", column=" + this.column + ")";
        }
    }
}

