/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddrn;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.opendatadiscovery.oddrn.JdbcProcessors;
import org.opendatadiscovery.oddrn.model.OddrnPath;

public class JdbcUrlParser {
    private static final String JDBC_PREFIX = "jdbc:";
    private static final String SEPARATOR = "://";
    private static final String DEFAULT_DB_NAME = "default";
    private final JdbcProcessors jdbcProcessors = new JdbcProcessors();

    public OddrnPath parse(String url) {
        return this.parse(url, DEFAULT_DB_NAME);
    }

    public OddrnPath parse(String url, String user) {
        String database;
        String host;
        if (url == null || !url.startsWith(JDBC_PREFIX) || url.indexOf(58, JDBC_PREFIX.length()) == -1) {
            throw new IllegalArgumentException("Invalid JDBC url.");
        }
        int separatorPos = url.indexOf(SEPARATOR, JDBC_PREFIX.length());
        if (separatorPos == -1) {
            throw new IllegalArgumentException("Invalid JDBC url.");
        }
        String urlSecondPart = url.substring(separatorPos + SEPARATOR.length());
        String driver = url.substring(JDBC_PREFIX.length(), separatorPos);
        int dbPos = urlSecondPart.indexOf("/");
        int paramsPos = urlSecondPart.indexOf("?");
        int semicolonParamsPos = urlSecondPart.indexOf(";");
        if (semicolonParamsPos > 0 && semicolonParamsPos < paramsPos) {
            paramsPos = semicolonParamsPos;
        } else if (paramsPos == -1 && semicolonParamsPos > 0) {
            paramsPos = semicolonParamsPos;
        }
        if (dbPos < 0 && paramsPos > 0) {
            host = urlSecondPart.substring(0, paramsPos);
            database = user;
        } else if (dbPos > 0 && paramsPos > 0) {
            host = urlSecondPart.substring(0, dbPos);
            database = urlSecondPart.substring(dbPos + 1, paramsPos);
        } else if (dbPos > 0 && paramsPos < 0) {
            host = urlSecondPart.substring(0, dbPos);
            database = urlSecondPart.substring(dbPos + 1);
        } else {
            host = urlSecondPart;
            database = null;
        }
        HostUserPath hostUserPath = this.parseHostUserPath(host);
        String generatedHost = hostUserPath.host;
        String generatedUser = hostUserPath.user != null ? hostUserPath.user : user;
        String generatedDatabase = (database == null || database.isEmpty()) && generatedUser != null ? generatedUser : database;
        return this.jdbcProcessors.path(driver, generatedHost, generatedDatabase);
    }

    private HostUserPath parseHostUserPath(String host) {
        String joinedHost;
        int userPassPos = host.indexOf("@");
        if (host.contains(",")) {
            String[] hosts = host.split(",");
            joinedHost = Arrays.stream(hosts).map(h -> this.replacePort((String)h, userPassPos)).collect(Collectors.joining(","));
        } else {
            joinedHost = this.replacePort(host, userPassPos);
        }
        if (userPassPos > 0) {
            String newHost = joinedHost.substring(userPassPos + 1);
            String userPass = joinedHost.substring(0, userPassPos);
            int passPos = userPass.indexOf(":");
            String user = passPos > 0 ? userPass.substring(0, passPos) : userPass;
            return new HostUserPath(newHost, user);
        }
        return new HostUserPath(joinedHost, null);
    }

    private String replacePort(String host, int userPassPos) {
        int portPos = host.lastIndexOf(":");
        return portPos > userPassPos ? host.substring(0, portPos) : host;
    }

    private static class HostUserPath {
        private final String host;
        private final String user;

        public HostUserPath(String host, String user) {
            this.host = host;
            this.user = user;
        }

        public String getHost() {
            return this.host;
        }

        public String getUser() {
            return this.user;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HostUserPath)) {
                return false;
            }
            HostUserPath other = (HostUserPath)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$host = this.getHost();
            String other$host = other.getHost();
            if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
                return false;
            }
            String this$user = this.getUser();
            String other$user = other.getUser();
            return !(this$user == null ? other$user != null : !this$user.equals(other$user));
        }

        protected boolean canEqual(Object other) {
            return other instanceof HostUserPath;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $host = this.getHost();
            result = result * 59 + ($host == null ? 43 : $host.hashCode());
            String $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : $user.hashCode());
            return result;
        }

        public String toString() {
            return "JdbcUrlParser.HostUserPath(host=" + this.getHost() + ", user=" + this.getUser() + ")";
        }
    }
}

