/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddplatform.ingestion.contract.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class MetadataExtension {
    @JsonProperty(value="schema_url")
    private URI schemaUrl;
    @JsonProperty(value="metadata")
    private Map<String, Object> metadata = new HashMap<String, Object>();

    public MetadataExtension schemaUrl(URI schemaUrl) {
        this.schemaUrl = schemaUrl;
        return this;
    }

    @ApiModelProperty(example="https://raw.githubusercontent.com/opendatadiscovery/opendatadiscovery-specification/main/specification/extensions/glue.json#/definitions/GlueDataSetExtension", required=true, value="The JSON Pointer (https://tools.ietf.org/html/rfc6901) URL to the corresponding version of the schema definition for this extension")
    public URI getSchemaUrl() {
        return this.schemaUrl;
    }

    public void setSchemaUrl(URI schemaUrl) {
        this.schemaUrl = schemaUrl;
    }

    public MetadataExtension metadata(Map<String, Object> metadata) {
        this.metadata = metadata;
        return this;
    }

    public MetadataExtension putMetadataItem(String key, Object metadataItem) {
        this.metadata.put(key, metadataItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataExtension metadataExtension = (MetadataExtension)o;
        return Objects.equals(this.schemaUrl, metadataExtension.schemaUrl) && Objects.equals(this.metadata, metadataExtension.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.schemaUrl, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetadataExtension {\n");
        sb.append("    schemaUrl: ").append(this.toIndentedString(this.schemaUrl)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

