/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddplatform.ingestion.contract.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataSetFieldEnumValue;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataSetFieldStat;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataSetFieldType;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.MetadataExtension;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.Tag;

public class DataSetField {
    @JsonProperty(value="oddrn")
    private String oddrn;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="version")
    private String version;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="owner")
    private String owner;
    @JsonProperty(value="metadata")
    private List<MetadataExtension> metadata = null;
    @JsonProperty(value="tags")
    private List<Tag> tags = null;
    @JsonProperty(value="parent_field_oddrn")
    private String parentFieldOddrn;
    @JsonProperty(value="type")
    private DataSetFieldType type;
    @JsonProperty(value="is_primary_key")
    private Boolean isPrimaryKey;
    @JsonProperty(value="is_sort_key")
    private Boolean isSortKey;
    @JsonProperty(value="is_key")
    private Boolean isKey;
    @JsonProperty(value="is_value")
    private Boolean isValue;
    @JsonProperty(value="default_value")
    private String defaultValue;
    @JsonProperty(value="stats")
    private DataSetFieldStat stats;
    @JsonProperty(value="enum_values")
    private List<DataSetFieldEnumValue> enumValues = null;

    public DataSetField oddrn(String oddrn) {
        this.oddrn = oddrn;
        return this;
    }

    @ApiModelProperty(example="//aws/glue/{account_id}/{database}/{tablename}", required=true, value="")
    public String getOddrn() {
        return this.oddrn;
    }

    public void setOddrn(String oddrn) {
        this.oddrn = oddrn;
    }

    public DataSetField name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DataSetField version(String version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(value="")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public DataSetField description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public DataSetField owner(String owner) {
        this.owner = owner;
        return this;
    }

    @ApiModelProperty(example="//aws/iam/{account_id}/user/name", value="")
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public DataSetField metadata(List<MetadataExtension> metadata) {
        this.metadata = metadata;
        return this;
    }

    public DataSetField addMetadataItem(MetadataExtension metadataItem) {
        if (this.metadata == null) {
            this.metadata = new ArrayList<MetadataExtension>();
        }
        this.metadata.add(metadataItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<MetadataExtension> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(List<MetadataExtension> metadata) {
        this.metadata = metadata;
    }

    public DataSetField tags(List<Tag> tags) {
        this.tags = tags;
        return this;
    }

    public DataSetField addTagsItem(Tag tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<Tag>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public DataSetField parentFieldOddrn(String parentFieldOddrn) {
        this.parentFieldOddrn = parentFieldOddrn;
        return this;
    }

    @ApiModelProperty(value="")
    public String getParentFieldOddrn() {
        return this.parentFieldOddrn;
    }

    public void setParentFieldOddrn(String parentFieldOddrn) {
        this.parentFieldOddrn = parentFieldOddrn;
    }

    public DataSetField type(DataSetFieldType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public DataSetFieldType getType() {
        return this.type;
    }

    public void setType(DataSetFieldType type) {
        this.type = type;
    }

    public DataSetField isPrimaryKey(Boolean isPrimaryKey) {
        this.isPrimaryKey = isPrimaryKey;
        return this;
    }

    @ApiModelProperty(value="")
    public Boolean getIsPrimaryKey() {
        return this.isPrimaryKey;
    }

    public void setIsPrimaryKey(Boolean isPrimaryKey) {
        this.isPrimaryKey = isPrimaryKey;
    }

    public DataSetField isSortKey(Boolean isSortKey) {
        this.isSortKey = isSortKey;
        return this;
    }

    @ApiModelProperty(value="")
    public Boolean getIsSortKey() {
        return this.isSortKey;
    }

    public void setIsSortKey(Boolean isSortKey) {
        this.isSortKey = isSortKey;
    }

    public DataSetField isKey(Boolean isKey) {
        this.isKey = isKey;
        return this;
    }

    @ApiModelProperty(value="")
    public Boolean getIsKey() {
        return this.isKey;
    }

    public void setIsKey(Boolean isKey) {
        this.isKey = isKey;
    }

    public DataSetField isValue(Boolean isValue) {
        this.isValue = isValue;
        return this;
    }

    @ApiModelProperty(value="")
    public Boolean getIsValue() {
        return this.isValue;
    }

    public void setIsValue(Boolean isValue) {
        this.isValue = isValue;
    }

    public DataSetField defaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    @ApiModelProperty(value="")
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public DataSetField stats(DataSetFieldStat stats) {
        this.stats = stats;
        return this;
    }

    @ApiModelProperty(value="")
    public DataSetFieldStat getStats() {
        return this.stats;
    }

    public void setStats(DataSetFieldStat stats) {
        this.stats = stats;
    }

    public DataSetField enumValues(List<DataSetFieldEnumValue> enumValues) {
        this.enumValues = enumValues;
        return this;
    }

    public DataSetField addEnumValuesItem(DataSetFieldEnumValue enumValuesItem) {
        if (this.enumValues == null) {
            this.enumValues = new ArrayList<DataSetFieldEnumValue>();
        }
        this.enumValues.add(enumValuesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<DataSetFieldEnumValue> getEnumValues() {
        return this.enumValues;
    }

    public void setEnumValues(List<DataSetFieldEnumValue> enumValues) {
        this.enumValues = enumValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSetField dataSetField = (DataSetField)o;
        return Objects.equals(this.oddrn, dataSetField.oddrn) && Objects.equals(this.name, dataSetField.name) && Objects.equals(this.version, dataSetField.version) && Objects.equals(this.description, dataSetField.description) && Objects.equals(this.owner, dataSetField.owner) && Objects.equals(this.metadata, dataSetField.metadata) && Objects.equals(this.tags, dataSetField.tags) && Objects.equals(this.parentFieldOddrn, dataSetField.parentFieldOddrn) && Objects.equals(this.type, dataSetField.type) && Objects.equals(this.isPrimaryKey, dataSetField.isPrimaryKey) && Objects.equals(this.isSortKey, dataSetField.isSortKey) && Objects.equals(this.isKey, dataSetField.isKey) && Objects.equals(this.isValue, dataSetField.isValue) && Objects.equals(this.defaultValue, dataSetField.defaultValue) && Objects.equals(this.stats, dataSetField.stats) && Objects.equals(this.enumValues, dataSetField.enumValues);
    }

    public int hashCode() {
        return Objects.hash(this.oddrn, this.name, this.version, this.description, this.owner, this.metadata, this.tags, this.parentFieldOddrn, this.type, this.isPrimaryKey, this.isSortKey, this.isKey, this.isValue, this.defaultValue, this.stats, this.enumValues);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DataSetField {\n");
        sb.append("    oddrn: ").append(this.toIndentedString(this.oddrn)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    parentFieldOddrn: ").append(this.toIndentedString(this.parentFieldOddrn)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    isPrimaryKey: ").append(this.toIndentedString(this.isPrimaryKey)).append("\n");
        sb.append("    isSortKey: ").append(this.toIndentedString(this.isSortKey)).append("\n");
        sb.append("    isKey: ").append(this.toIndentedString(this.isKey)).append("\n");
        sb.append("    isValue: ").append(this.toIndentedString(this.isValue)).append("\n");
        sb.append("    defaultValue: ").append(this.toIndentedString(this.defaultValue)).append("\n");
        sb.append("    stats: ").append(this.toIndentedString(this.stats)).append("\n");
        sb.append("    enumValues: ").append(this.toIndentedString(this.enumValues)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

