/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddplatform.ingestion.contract.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataConsumer;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataEntityGroup;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataEntityType;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataInput;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataQualityTest;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataQualityTestRun;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataSet;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataTransformer;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataTransformerRun;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.MetadataExtension;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.Tag;
import org.springframework.format.annotation.DateTimeFormat;

public class DataEntity {
    @JsonProperty(value="oddrn")
    private String oddrn;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="version")
    private String version;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="owner")
    private String owner;
    @JsonProperty(value="metadata")
    private List<MetadataExtension> metadata = null;
    @JsonProperty(value="tags")
    private List<Tag> tags = null;
    @JsonProperty(value="updated_at")
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime updatedAt;
    @JsonProperty(value="created_at")
    @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME)
    private OffsetDateTime createdAt;
    @JsonProperty(value="type")
    private DataEntityType type;
    @JsonProperty(value="dataset")
    private DataSet dataset;
    @JsonProperty(value="data_transformer")
    private DataTransformer dataTransformer;
    @JsonProperty(value="data_transformer_run")
    private DataTransformerRun dataTransformerRun;
    @JsonProperty(value="data_quality_test")
    private DataQualityTest dataQualityTest;
    @JsonProperty(value="data_quality_test_run")
    private DataQualityTestRun dataQualityTestRun;
    @JsonProperty(value="data_input")
    private DataInput dataInput;
    @JsonProperty(value="data_consumer")
    private DataConsumer dataConsumer;
    @JsonProperty(value="data_entity_group")
    private DataEntityGroup dataEntityGroup;

    public DataEntity oddrn(String oddrn) {
        this.oddrn = oddrn;
        return this;
    }

    @ApiModelProperty(example="//aws/glue/{account_id}/{database}/{tablename}", required=true, value="")
    public String getOddrn() {
        return this.oddrn;
    }

    public void setOddrn(String oddrn) {
        this.oddrn = oddrn;
    }

    public DataEntity name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DataEntity version(String version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(value="")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public DataEntity description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public DataEntity owner(String owner) {
        this.owner = owner;
        return this;
    }

    @ApiModelProperty(example="//aws/iam/{account_id}/user/name", value="")
    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public DataEntity metadata(List<MetadataExtension> metadata) {
        this.metadata = metadata;
        return this;
    }

    public DataEntity addMetadataItem(MetadataExtension metadataItem) {
        if (this.metadata == null) {
            this.metadata = new ArrayList<MetadataExtension>();
        }
        this.metadata.add(metadataItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<MetadataExtension> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(List<MetadataExtension> metadata) {
        this.metadata = metadata;
    }

    public DataEntity tags(List<Tag> tags) {
        this.tags = tags;
        return this;
    }

    public DataEntity addTagsItem(Tag tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<Tag>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public DataEntity updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public DataEntity createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(value="")
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public DataEntity type(DataEntityType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public DataEntityType getType() {
        return this.type;
    }

    public void setType(DataEntityType type) {
        this.type = type;
    }

    public DataEntity dataset(DataSet dataset) {
        this.dataset = dataset;
        return this;
    }

    @ApiModelProperty(value="")
    public DataSet getDataset() {
        return this.dataset;
    }

    public void setDataset(DataSet dataset) {
        this.dataset = dataset;
    }

    public DataEntity dataTransformer(DataTransformer dataTransformer) {
        this.dataTransformer = dataTransformer;
        return this;
    }

    @ApiModelProperty(value="")
    public DataTransformer getDataTransformer() {
        return this.dataTransformer;
    }

    public void setDataTransformer(DataTransformer dataTransformer) {
        this.dataTransformer = dataTransformer;
    }

    public DataEntity dataTransformerRun(DataTransformerRun dataTransformerRun) {
        this.dataTransformerRun = dataTransformerRun;
        return this;
    }

    @ApiModelProperty(value="")
    public DataTransformerRun getDataTransformerRun() {
        return this.dataTransformerRun;
    }

    public void setDataTransformerRun(DataTransformerRun dataTransformerRun) {
        this.dataTransformerRun = dataTransformerRun;
    }

    public DataEntity dataQualityTest(DataQualityTest dataQualityTest) {
        this.dataQualityTest = dataQualityTest;
        return this;
    }

    @ApiModelProperty(value="")
    public DataQualityTest getDataQualityTest() {
        return this.dataQualityTest;
    }

    public void setDataQualityTest(DataQualityTest dataQualityTest) {
        this.dataQualityTest = dataQualityTest;
    }

    public DataEntity dataQualityTestRun(DataQualityTestRun dataQualityTestRun) {
        this.dataQualityTestRun = dataQualityTestRun;
        return this;
    }

    @ApiModelProperty(value="")
    public DataQualityTestRun getDataQualityTestRun() {
        return this.dataQualityTestRun;
    }

    public void setDataQualityTestRun(DataQualityTestRun dataQualityTestRun) {
        this.dataQualityTestRun = dataQualityTestRun;
    }

    public DataEntity dataInput(DataInput dataInput) {
        this.dataInput = dataInput;
        return this;
    }

    @ApiModelProperty(value="")
    public DataInput getDataInput() {
        return this.dataInput;
    }

    public void setDataInput(DataInput dataInput) {
        this.dataInput = dataInput;
    }

    public DataEntity dataConsumer(DataConsumer dataConsumer) {
        this.dataConsumer = dataConsumer;
        return this;
    }

    @ApiModelProperty(value="")
    public DataConsumer getDataConsumer() {
        return this.dataConsumer;
    }

    public void setDataConsumer(DataConsumer dataConsumer) {
        this.dataConsumer = dataConsumer;
    }

    public DataEntity dataEntityGroup(DataEntityGroup dataEntityGroup) {
        this.dataEntityGroup = dataEntityGroup;
        return this;
    }

    @ApiModelProperty(value="")
    public DataEntityGroup getDataEntityGroup() {
        return this.dataEntityGroup;
    }

    public void setDataEntityGroup(DataEntityGroup dataEntityGroup) {
        this.dataEntityGroup = dataEntityGroup;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataEntity dataEntity = (DataEntity)o;
        return Objects.equals(this.oddrn, dataEntity.oddrn) && Objects.equals(this.name, dataEntity.name) && Objects.equals(this.version, dataEntity.version) && Objects.equals(this.description, dataEntity.description) && Objects.equals(this.owner, dataEntity.owner) && Objects.equals(this.metadata, dataEntity.metadata) && Objects.equals(this.tags, dataEntity.tags) && Objects.equals(this.updatedAt, dataEntity.updatedAt) && Objects.equals(this.createdAt, dataEntity.createdAt) && Objects.equals((Object)this.type, (Object)dataEntity.type) && Objects.equals(this.dataset, dataEntity.dataset) && Objects.equals(this.dataTransformer, dataEntity.dataTransformer) && Objects.equals(this.dataTransformerRun, dataEntity.dataTransformerRun) && Objects.equals(this.dataQualityTest, dataEntity.dataQualityTest) && Objects.equals(this.dataQualityTestRun, dataEntity.dataQualityTestRun) && Objects.equals(this.dataInput, dataEntity.dataInput) && Objects.equals(this.dataConsumer, dataEntity.dataConsumer) && Objects.equals(this.dataEntityGroup, dataEntity.dataEntityGroup);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.oddrn, this.name, this.version, this.description, this.owner, this.metadata, this.tags, this.updatedAt, this.createdAt, this.type, this.dataset, this.dataTransformer, this.dataTransformerRun, this.dataQualityTest, this.dataQualityTestRun, this.dataInput, this.dataConsumer, this.dataEntityGroup});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DataEntity {\n");
        sb.append("    oddrn: ").append(this.toIndentedString(this.oddrn)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    owner: ").append(this.toIndentedString(this.owner)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    dataset: ").append(this.toIndentedString(this.dataset)).append("\n");
        sb.append("    dataTransformer: ").append(this.toIndentedString(this.dataTransformer)).append("\n");
        sb.append("    dataTransformerRun: ").append(this.toIndentedString(this.dataTransformerRun)).append("\n");
        sb.append("    dataQualityTest: ").append(this.toIndentedString(this.dataQualityTest)).append("\n");
        sb.append("    dataQualityTestRun: ").append(this.toIndentedString(this.dataQualityTestRun)).append("\n");
        sb.append("    dataInput: ").append(this.toIndentedString(this.dataInput)).append("\n");
        sb.append("    dataConsumer: ").append(this.toIndentedString(this.dataConsumer)).append("\n");
        sb.append("    dataEntityGroup: ").append(this.toIndentedString(this.dataEntityGroup)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

