/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.oddplatform.ingestion.contract.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.opendatadiscovery.oddplatform.ingestion.contract.api.ApiUtil;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.CompactDataEntityList;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataEntityList;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DataSourceList;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.DatasetStatisticsList;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.IngestionAlertList;
import org.opendatadiscovery.oddplatform.ingestion.contract.model.MetricSetList;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import springfox.documentation.annotations.ApiIgnore;

@Api(value="ingestion", description="the ingestion API")
public interface IngestionApi {
    @ApiOperation(value="", nickname="createAlerts", notes="Alerts target catalog about ingestion issues", tags={"OpenDataDiscoveryIngestion"})
    @ApiResponses(value={@ApiResponse(code=201, message="Created")})
    @PostMapping(value={"/ingestion/alerts"}, consumes={"application/json"})
    default public Mono<ResponseEntity<Void>> createAlerts(@ApiParam(value="") @RequestBody(required=false) Mono<IngestionAlertList> ingestionAlertList, @ApiIgnore ServerWebExchange exchange) {
        Mono result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        return result.then(Mono.empty());
    }

    @ApiOperation(value="", nickname="createDataSource", notes="Creates data sources in the target catalog", tags={"OpenDataDiscoveryIngestion"})
    @ApiResponses(value={@ApiResponse(code=201, message="Created")})
    @PostMapping(value={"/ingestion/datasources"}, consumes={"application/json"})
    default public Mono<ResponseEntity<Void>> createDataSource(@ApiParam(value="") @RequestBody(required=false) Mono<DataSourceList> dataSourceList, @ApiIgnore ServerWebExchange exchange) {
        Mono result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        return result.then(Mono.empty());
    }

    @ApiOperation(value="", nickname="getDataEntitiesByDEGOddrn", notes="Searches for data entities in the target catalog by oddrn of a DEG they are currently part of", response=CompactDataEntityList.class, tags={"OpenDataDiscoveryIngestion"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=CompactDataEntityList.class)})
    @GetMapping(value={"/ingestion/entities/degs/children"}, produces={"application/json"})
    default public Mono<ResponseEntity<CompactDataEntityList>> getDataEntitiesByDEGOddrn(@ApiParam(value="", required=true) @RequestParam(value="oddrn", required=true) String oddrn, @ApiIgnore ServerWebExchange exchange) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
            String exampleString = "{ \"items\" : [ { \"oddrn\" : \"oddrn\" }, { \"oddrn\" : \"oddrn\" } ] }";
            result = ApiUtil.getExampleResponse(exchange, exampleString);
            break;
        }
        return result.then(Mono.empty());
    }

    @ApiOperation(value="", nickname="ingestMetrics", notes="Ingests list of metrics", tags={"OpenDataDiscoveryIngestion"})
    @ApiResponses(value={@ApiResponse(code=201, message="Created")})
    @PostMapping(value={"/ingestion/metrics"}, consumes={"application/json"})
    default public Mono<ResponseEntity<Void>> ingestMetrics(@ApiParam(value="", required=true) @RequestBody Mono<MetricSetList> metricSetList, @ApiIgnore ServerWebExchange exchange) {
        Mono result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        return result.then(Mono.empty());
    }

    @ApiOperation(value="", nickname="postDataEntityList", notes="Ingests list of data entities", tags={"OpenDataDiscoveryIngestion"})
    @ApiResponses(value={@ApiResponse(code=201, message="Created")})
    @PostMapping(value={"/ingestion/entities"}, consumes={"application/json"})
    default public Mono<ResponseEntity<Void>> postDataEntityList(@ApiParam(value="", required=true) @RequestBody Mono<DataEntityList> dataEntityList, @ApiIgnore ServerWebExchange exchange) {
        Mono result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        return result.then(Mono.empty());
    }

    @ApiOperation(value="", nickname="postDataSetStatsList", notes="Ingests list of stats for data sets", tags={"OpenDataDiscoveryIngestion"})
    @ApiResponses(value={@ApiResponse(code=201, message="Created")})
    @PostMapping(value={"/ingestion/entities/datasets/stats"}, consumes={"application/json"})
    default public Mono<ResponseEntity<Void>> postDataSetStatsList(@ApiParam(value="", required=true) @RequestBody Mono<DatasetStatisticsList> datasetStatisticsList, @ApiIgnore ServerWebExchange exchange) {
        Mono result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        return result.then(Mono.empty());
    }
}

