/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendatadiscovery.client.model.Label;

@JsonPropertyOrder(value={"value", "timestamp", "label"})
public class Exemplar {
    public static final String JSON_PROPERTY_VALUE = "value";
    private BigDecimal value;
    public static final String JSON_PROPERTY_TIMESTAMP = "timestamp";
    private Integer timestamp;
    public static final String JSON_PROPERTY_LABEL = "label";
    private List<Label> label;

    public Exemplar value(BigDecimal value) {
        this.value = value;
        return this;
    }

    @Nonnull
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BigDecimal getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setValue(BigDecimal value) {
        this.value = value;
    }

    public Exemplar timestamp(Integer timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @Nullable
    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTimestamp(Integer timestamp) {
        this.timestamp = timestamp;
    }

    public Exemplar label(List<Label> label) {
        this.label = label;
        return this;
    }

    public Exemplar addLabelItem(Label labelItem) {
        if (this.label == null) {
            this.label = new ArrayList<Label>();
        }
        this.label.add(labelItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="label")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<Label> getLabel() {
        return this.label;
    }

    @JsonProperty(value="label")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLabel(List<Label> label) {
        this.label = label;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Exemplar exemplar = (Exemplar)o;
        return Objects.equals(this.value, exemplar.value) && Objects.equals(this.timestamp, exemplar.timestamp) && Objects.equals(this.label, exemplar.label);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.timestamp, this.label);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Exemplar {\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    timestamp: ").append(this.toIndentedString(this.timestamp)).append("\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

