/*
 * Decompiled with CFR 0.152.
 */
package org.opendatadiscovery.client.api;

import java.util.HashMap;
import java.util.List;
import org.opendatadiscovery.client.ApiClient;
import org.opendatadiscovery.client.model.CompactDataEntityList;
import org.opendatadiscovery.client.model.DataEntityList;
import org.opendatadiscovery.client.model.DataSourceList;
import org.opendatadiscovery.client.model.DatasetStatisticsList;
import org.opendatadiscovery.client.model.IngestionAlertList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

public class OpenDataDiscoveryIngestionApi {
    private ApiClient apiClient;

    public OpenDataDiscoveryIngestionApi() {
        this(new ApiClient());
    }

    @Autowired
    public OpenDataDiscoveryIngestionApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createAlertsRequestCreation(IngestionAlertList ingestionAlertList) throws WebClientResponseException {
        IngestionAlertList postBody = ingestionAlertList;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/ingestion/alerts", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Void> createAlerts(IngestionAlertList ingestionAlertList) throws WebClientResponseException {
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>(){};
        return this.createAlertsRequestCreation(ingestionAlertList).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Void>> createAlertsWithHttpInfo(IngestionAlertList ingestionAlertList) throws WebClientResponseException {
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>(){};
        return this.createAlertsRequestCreation(ingestionAlertList).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec createDataSourceRequestCreation(DataSourceList dataSourceList) throws WebClientResponseException {
        DataSourceList postBody = dataSourceList;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/ingestion/datasources", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Void> createDataSource(DataSourceList dataSourceList) throws WebClientResponseException {
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>(){};
        return this.createDataSourceRequestCreation(dataSourceList).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Void>> createDataSourceWithHttpInfo(DataSourceList dataSourceList) throws WebClientResponseException {
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>(){};
        return this.createDataSourceRequestCreation(dataSourceList).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec getDataEntitiesByDEGOddrnRequestCreation(String oddrn) throws WebClientResponseException {
        Object postBody = null;
        if (oddrn == null) {
            throw new WebClientResponseException("Missing the required parameter 'oddrn' when calling getDataEntitiesByDEGOddrn", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "oddrn", oddrn));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<CompactDataEntityList> localVarReturnType = new ParameterizedTypeReference<CompactDataEntityList>(){};
        return this.apiClient.invokeAPI("/ingestion/entities/degs/children", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<CompactDataEntityList> getDataEntitiesByDEGOddrn(String oddrn) throws WebClientResponseException {
        ParameterizedTypeReference<CompactDataEntityList> localVarReturnType = new ParameterizedTypeReference<CompactDataEntityList>(){};
        return this.getDataEntitiesByDEGOddrnRequestCreation(oddrn).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<CompactDataEntityList>> getDataEntitiesByDEGOddrnWithHttpInfo(String oddrn) throws WebClientResponseException {
        ParameterizedTypeReference<CompactDataEntityList> localVarReturnType = new ParameterizedTypeReference<CompactDataEntityList>(){};
        return this.getDataEntitiesByDEGOddrnRequestCreation(oddrn).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec postDataEntityListRequestCreation(DataEntityList dataEntityList) throws WebClientResponseException {
        DataEntityList postBody = dataEntityList;
        if (dataEntityList == null) {
            throw new WebClientResponseException("Missing the required parameter 'dataEntityList' when calling postDataEntityList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/ingestion/entities", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Void> postDataEntityList(DataEntityList dataEntityList) throws WebClientResponseException {
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>(){};
        return this.postDataEntityListRequestCreation(dataEntityList).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Void>> postDataEntityListWithHttpInfo(DataEntityList dataEntityList) throws WebClientResponseException {
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>(){};
        return this.postDataEntityListRequestCreation(dataEntityList).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec postDataSetStatsListRequestCreation(DatasetStatisticsList datasetStatisticsList) throws WebClientResponseException {
        DatasetStatisticsList postBody = datasetStatisticsList;
        if (datasetStatisticsList == null) {
            throw new WebClientResponseException("Missing the required parameter 'datasetStatisticsList' when calling postDataSetStatsList", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/ingestion/entities/datasets/stats", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Void> postDataSetStatsList(DatasetStatisticsList datasetStatisticsList) throws WebClientResponseException {
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>(){};
        return this.postDataSetStatsListRequestCreation(datasetStatisticsList).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Void>> postDataSetStatsListWithHttpInfo(DatasetStatisticsList datasetStatisticsList) throws WebClientResponseException {
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>(){};
        return this.postDataSetStatsListRequestCreation(datasetStatisticsList).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

