/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.gremlin.client;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.opencypher.gremlin.client.CommonResultSets;
import org.opencypher.gremlin.client.CypherGremlinClient;
import org.opencypher.gremlin.client.CypherResultSet;
import org.opencypher.gremlin.client.CypherStatement;
import org.opencypher.gremlin.translation.CypherAst;
import org.opencypher.gremlin.translation.StatementOption;
import org.opencypher.gremlin.translation.groovy.GroovyPredicate;
import org.opencypher.gremlin.translation.translator.Translator;
import org.opencypher.gremlin.traversal.ParameterNormalizer;
import org.opencypher.gremlin.traversal.ReturnNormalizer;

final class SyncGroovyCypherGremlinClient
implements CypherGremlinClient {
    private final Client client;
    private final Supplier<Translator<String, GroovyPredicate>> translatorSupplier;

    SyncGroovyCypherGremlinClient(Client client, Supplier<Translator<String, GroovyPredicate>> translatorSupplier) {
        this.client = client;
        this.translatorSupplier = translatorSupplier;
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public CypherResultSet submit(String cypher) {
        return this.submit(cypher, new HashMap());
    }

    public CypherResultSet submit(CypherStatement statement) {
        Map normalizedParameters = ParameterNormalizer.normalize(statement.parameters());
        CypherAst ast = CypherAst.parse((String)statement.query(), (Map)normalizedParameters);
        if (ast.getOptions().contains(StatementOption.EXPLAIN)) {
            return CommonResultSets.explain(ast);
        }
        Translator<String, GroovyPredicate> translator = this.translatorSupplier.get();
        String gremlin = (String)ast.buildTranslation(translator);
        ReturnNormalizer returnNormalizer = ReturnNormalizer.create((Map)ast.getReturnTypes());
        try {
            CypherStatement.Simple updatedStatement = CypherStatement.create(statement.query(), normalizedParameters);
            List resultSet = (List)this.client.submit(gremlin, updatedStatement.requestOptions()).all().get();
            return new CypherResultSet(resultSet.iterator(), arg_0 -> ((ReturnNormalizer)returnNormalizer).normalize(arg_0));
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CompletableFuture<CypherResultSet> submitAsync(CypherStatement statement) {
        CypherResultSet result = this.submit(statement);
        return CompletableFuture.completedFuture(result);
    }
}

