/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.gremlin.client;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.ResultSet;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.opencypher.gremlin.client.CypherGremlinClient;
import org.opencypher.gremlin.client.CypherResultSet;
import org.opencypher.gremlin.client.CypherStatement;

final class OpProcessorCypherGremlinClient
implements CypherGremlinClient {
    private static final String CYPHER_OP_PROCESSOR_NAME = "cypher";
    private final Client client;

    OpProcessorCypherGremlinClient(Client client) {
        this.client = client;
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public CompletableFuture<CypherResultSet> submitAsync(CypherStatement statement) {
        RequestMessage requestMessage = OpProcessorCypherGremlinClient.buildRequest(statement).create();
        CompletableFuture resultSetFuture = this.client.submitAsync(requestMessage);
        return ((CompletableFuture)resultSetFuture.thenApply(ResultSet::iterator)).thenApply(CypherResultSet::new);
    }

    private static RequestMessage.Builder buildRequest(CypherStatement statement) {
        Map<String, Object> parameters = statement.parameters();
        RequestMessage.Builder request = RequestMessage.build((String)"eval").processor(CYPHER_OP_PROCESSOR_NAME).add(new Object[]{"gremlin", statement.query()});
        statement.timeout().ifPresent(timeout -> request.add(new Object[]{"scriptEvaluationTimeout", timeout}));
        if (parameters != null && !parameters.isEmpty()) {
            request.addArg("bindings", parameters);
        }
        return request;
    }
}

