/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.gremlin.client;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.driver.Result;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.DefaultGraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.opencypher.gremlin.client.CommonResultSets;
import org.opencypher.gremlin.client.CypherGremlinClient;
import org.opencypher.gremlin.client.CypherResultSet;
import org.opencypher.gremlin.client.CypherStatement;
import org.opencypher.gremlin.translation.CypherAst;
import org.opencypher.gremlin.translation.StatementOption;
import org.opencypher.gremlin.translation.translator.Translator;
import org.opencypher.gremlin.traversal.ParameterNormalizer;
import org.opencypher.gremlin.traversal.ReturnNormalizer;

final class InMemoryCypherGremlinClient
implements CypherGremlinClient {
    private final GraphTraversalSource gts;

    InMemoryCypherGremlinClient(GraphTraversalSource gts) {
        this.gts = gts;
    }

    @Override
    public void close() {
    }

    @Override
    public CompletableFuture<CypherResultSet> submitAsync(CypherStatement statement) {
        CypherAst ast;
        Map normalizedParameters = ParameterNormalizer.normalize(statement.parameters());
        try {
            ast = CypherAst.parse((String)statement.query(), (Map)normalizedParameters);
        }
        catch (Exception e) {
            return CompletableFuture.completedFuture(CommonResultSets.exceptional(e));
        }
        if (ast.getOptions().contains(StatementOption.EXPLAIN)) {
            return CompletableFuture.completedFuture(CommonResultSets.explain(ast));
        }
        DefaultGraphTraversal g = new DefaultGraphTraversal(this.gts.clone());
        Translator translator = Translator.builder().traversal((GraphTraversal)g).enableCypherExtensions().build();
        GraphTraversal traversal = (GraphTraversal)ast.buildTranslation(translator);
        ReturnNormalizer returnNormalizer = ReturnNormalizer.create((Map)ast.getReturnTypes());
        List results = traversal.toStream().map(arg_0 -> ((ReturnNormalizer)returnNormalizer).normalize(arg_0)).map(Result::new).collect(Collectors.toList());
        return CompletableFuture.completedFuture(new CypherResultSet(results.iterator()));
    }
}

