/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.gremlin.client;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.apache.tinkerpop.gremlin.driver.Client;
import org.apache.tinkerpop.gremlin.driver.Result;
import org.apache.tinkerpop.gremlin.driver.ResultSet;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.opencypher.gremlin.client.CommonResultSets;
import org.opencypher.gremlin.client.CypherGremlinClient;
import org.opencypher.gremlin.client.CypherResultSet;
import org.opencypher.gremlin.client.CypherStatement;
import org.opencypher.gremlin.translation.CypherAst;
import org.opencypher.gremlin.translation.StatementOption;
import org.opencypher.gremlin.translation.groovy.GroovyPredicate;
import org.opencypher.gremlin.translation.translator.Translator;
import org.opencypher.gremlin.traversal.ParameterNormalizer;
import org.opencypher.gremlin.traversal.ReturnNormalizer;

final class GroovyCypherGremlinClient
implements CypherGremlinClient {
    private final Client client;
    private final Supplier<Translator<String, GroovyPredicate>> translatorSupplier;

    GroovyCypherGremlinClient(Client client, Supplier<Translator<String, GroovyPredicate>> translatorSupplier) {
        this.client = client;
        this.translatorSupplier = translatorSupplier;
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public CompletableFuture<CypherResultSet> submitAsync(CypherStatement statement) {
        String gremlin;
        CypherAst ast;
        Map normalizedParameters = ParameterNormalizer.normalize(statement.parameters());
        try {
            ast = CypherAst.parse((String)statement.query(), (Map)normalizedParameters);
        }
        catch (Exception e) {
            return CompletableFuture.completedFuture(CommonResultSets.exceptional(e));
        }
        if (ast.getOptions().contains(StatementOption.EXPLAIN)) {
            return CompletableFuture.completedFuture(CommonResultSets.explain(ast));
        }
        Translator<String, GroovyPredicate> translator = this.translatorSupplier.get();
        try {
            gremlin = (String)ast.buildTranslation(translator);
        }
        catch (Exception e) {
            return CompletableFuture.completedFuture(CommonResultSets.exceptional(e));
        }
        RequestMessage request = GroovyCypherGremlinClient.buildRequest(gremlin, normalizedParameters, statement).create();
        CompletableFuture resultSetFuture = this.client.submitAsync(request);
        ReturnNormalizer returnNormalizer = ReturnNormalizer.create((Map)ast.getReturnTypes());
        return ((CompletableFuture)resultSetFuture.thenApply(ResultSet::iterator)).thenApply(resultIterator -> new CypherResultSet((Iterator<Result>)resultIterator, arg_0 -> ((ReturnNormalizer)returnNormalizer).normalize(arg_0)));
    }

    private static RequestMessage.Builder buildRequest(String query, Map<String, Object> normalizedParameters, CypherStatement statement) {
        RequestMessage.Builder request = RequestMessage.build((String)"eval").add(new Object[]{"gremlin", query});
        statement.timeout().ifPresent(t -> request.add(new Object[]{"scriptEvaluationTimeout", t}));
        if (!normalizedParameters.isEmpty()) {
            request.addArg("bindings", normalizedParameters);
        }
        return request;
    }
}

