/*
 * Decompiled with CFR 0.152.
 */
package org.opencypher.gremlin.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.tinkerpop.gremlin.driver.RequestOptions;
import org.opencypher.gremlin.client.CypherGremlinClient;
import org.opencypher.gremlin.client.CypherResultSet;

public class CypherStatement {
    protected final String query;
    protected final Long timeout;
    protected final Map<String, ?> parameters;

    private CypherStatement(String query, Long timeout, Map<String, ?> parameters) {
        this.query = query;
        this.timeout = timeout;
        this.parameters = parameters;
    }

    public static Simple create(String query) {
        return new Simple(query, null, Collections.emptyMap());
    }

    public static Simple create(String query, Map<String, ?> parameters) {
        return new Simple(query, null, new HashMap(parameters));
    }

    public String query() {
        return this.query;
    }

    public Map<String, Object> parameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public Optional<Long> timeout() {
        return Optional.ofNullable(this.timeout);
    }

    public RequestOptions requestOptions() {
        return this.timeout == null ? RequestOptions.EMPTY : RequestOptions.build().timeout(this.timeout.longValue()).create();
    }

    public static class Submittable
    extends Immutable<Submittable> {
        private CypherGremlinClient client;

        protected Submittable(CypherGremlinClient client, String query, Long timeout, Map<String, ?> parameters) {
            super(query, timeout, parameters);
            this.client = client;
        }

        public CompletableFuture<CypherResultSet> submit() {
            return this.client.submitAsync(this);
        }

        @Override
        protected Submittable instance(String query, Long timeout, Map<String, ?> parameters) {
            return new Submittable(this.client, query, timeout, parameters);
        }
    }

    public static class Simple
    extends Immutable<Simple> {
        protected Simple(String query, Long timeout, Map<String, ?> parameters) {
            super(query, timeout, parameters);
        }

        @Override
        protected Simple instance(String query, Long timeout, Map<String, ?> parameters) {
            return new Simple(query, timeout, parameters);
        }
    }

    private static abstract class Immutable<T extends Immutable<T>>
    extends CypherStatement {
        protected Immutable(String query, Long timeout, Map<String, ?> parameters) {
            super(query, timeout, parameters);
        }

        public T withParameters(Map<String, Object> newParameters) {
            return this.instance(this.query, this.timeout, new HashMap<String, Object>(newParameters));
        }

        public T addParameter(String name, Object value) {
            HashMap<String, Object> newParameters = new HashMap<String, Object>(this.parameters);
            newParameters.put(name, value);
            return this.instance(this.query, this.timeout, newParameters);
        }

        public T withTimeout(long timeout, TimeUnit unit) {
            return this.instance(this.query, unit.toMillis(timeout), this.parameters);
        }

        protected abstract T instance(String var1, Long var2, Map<String, ?> var3);
    }
}

